/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class Flashable {
    public static final String CLIENT_PROPERTY_FLASHABLE = "jide.flashable";
    private int _interval = 500;
    protected JComponent _component;
    protected Animator _animator;
    protected Timer _timer = null;
    private static boolean _synchronizedFlashFlag;
    private static Timer _synchronizedFlashTimer;

    public Flashable(JComponent jComponent) {
        this._component = jComponent;
        this.install(this._component);
    }

    public static boolean getSynchronizedFlashFlag() {
        return _synchronizedFlashFlag;
    }

    private void install(JComponent jComponent) {
        this._animator = new Animator(jComponent, 0, this.getInterval(), -1){

            protected Timer createTimer(int n, ActionListener actionListener) {
                if (_synchronizedFlashTimer == null) {
                    _synchronizedFlashTimer = new FlashTimer(n, actionListener);
                }
                _synchronizedFlashTimer.addActionListener(actionListener);
                return _synchronizedFlashTimer;
            }
        };
        this._animator.addAnimatorListener(new AnimatorListener(){

            public void animationStarts(Component component) {
            }

            public void animationFrame(Component component, int n, int n2) {
                Flashable.this.flash();
            }

            public void animationEnds(Component component) {
            }
        });
        jComponent.putClientProperty(CLIENT_PROPERTY_FLASHABLE, this);
    }

    public JComponent getComponent() {
        return this._component;
    }

    public void setComponent(JComponent jComponent) {
        JComponent jComponent2 = this._component;
        if (jComponent2 != jComponent) {
            this._component.putClientProperty(CLIENT_PROPERTY_FLASHABLE, null);
            this._component = jComponent;
            this._component.putClientProperty(CLIENT_PROPERTY_FLASHABLE, this);
        }
    }

    public int getInterval() {
        return this._interval;
    }

    public void setInterval(int n) {
        int n2 = this._interval;
        if (n2 != n) {
            this._interval = n;
            this.getAnimator().setDelay(n);
        }
    }

    public abstract void flash();

    public abstract void clearFlashing();

    protected Animator getAnimator() {
        return this._animator;
    }

    public void startFlashing() {
        this.clearFlashing();
        this.getAnimator().start();
    }

    public void stopFlashing() {
        this.clearFlashing();
        this.getAnimator().stop();
    }

    public void uninstall() {
        this.stopFlashing();
        this._animator.dispose();
        this._animator = null;
        this.getComponent().putClientProperty(CLIENT_PROPERTY_FLASHABLE, null);
    }

    public boolean isFlashing() {
        return this.getAnimator().isRunning();
    }

    public static boolean isFlashableInstalled(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_FLASHABLE);
        return object instanceof Flashable;
    }

    public static Flashable getFlashable(JComponent jComponent) {
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_FLASHABLE);
        if (object instanceof Flashable) {
            return (Flashable)object;
        }
        return null;
    }

    static class FlashTimer
    extends Timer
    implements ActionListener {
        public FlashTimer(int n, ActionListener actionListener) {
            super(n, actionListener);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            _synchronizedFlashFlag = !_synchronizedFlashFlag;
        }
    }
}

