/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "RangeSliderUI";

    public RangeSlider() {
    }

    public RangeSlider(int n) {
        super(n);
    }

    public RangeSlider(int n, int n2) {
        super(n, n2);
    }

    public RangeSlider(int n, int n2, int n3, int n4) {
        super(new DefaultBoundedRangeModel(n3, n4 - n3, n, n2));
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int n) {
        return n >= this.getLowValue() && n <= this.getHighValue();
    }

    public void setLowValue(int n) {
        int n2 = n + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int n3 = n2 - n;
        this.getModel().setRangeProperties(n, n3, this.getMinimum(), this.getMaximum(), true);
    }

    public void setHighValue(int n) {
        this.getModel().setExtent(n - this.getLowValue());
    }
}

