/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.FourthMoment;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class Kurtosis
extends AbstractStorelessUnivariateStatistic {
    private static final long serialVersionUID = 2784465764798260919L;
    protected FourthMoment moment;
    protected boolean incMoment;

    public Kurtosis() {
        this.incMoment = true;
        this.moment = new FourthMoment();
    }

    public Kurtosis(FourthMoment m4) {
        this.incMoment = false;
        this.moment = m4;
    }

    public void increment(double d) {
        if (!this.incMoment) {
            throw new IllegalStateException("Statistics constructed from external moments cannot be incremented");
        }
        this.moment.increment(d);
    }

    public double getResult() {
        double kurtosis = Double.NaN;
        if (this.moment.getN() > 3L) {
            double variance = this.moment.m2 / (double)(this.moment.n - 1L);
            if (this.moment.n <= 3L || variance < 1.0E-19) {
                kurtosis = 0.0;
            } else {
                double n = this.moment.n;
                kurtosis = (n * (n + 1.0) * this.moment.m4 - 3.0 * this.moment.m2 * this.moment.m2 * (n - 1.0)) / ((n - 1.0) * (n - 2.0) * (n - 3.0) * variance * variance);
            }
        }
        return kurtosis;
    }

    public void clear() {
        if (!this.incMoment) {
            throw new IllegalStateException("Statistics constructed from external moments cannot be cleared");
        }
        this.moment.clear();
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] values, int begin, int length) {
        double kurt = Double.NaN;
        if (this.test(values, begin, length) && length > 3) {
            Variance variance = new Variance();
            variance.incrementAll(values, begin, length);
            double mean = variance.moment.m1;
            double stdDev = Math.sqrt(variance.getResult());
            double accum3 = 0.0;
            int i = begin;
            while (i < begin + length) {
                accum3 += Math.pow(values[i] - mean, 4.0);
                ++i;
            }
            double n0 = length;
            double coefficientOne = n0 * (n0 + 1.0) / ((n0 - 1.0) * (n0 - 2.0) * (n0 - 3.0));
            double termTwo = 3.0 * Math.pow(n0 - 1.0, 2.0) / ((n0 - 2.0) * (n0 - 3.0));
            kurt = coefficientOne * (accum3 /= Math.pow(stdDev, 4.0)) - termTwo;
        }
        return kurt;
    }
}

