package org.broad.igv.scatterplot;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;

import java.util.*;

/**
 * @author Jim Robinson
 * @date 10/22/11
 */
public class ScatterPlotUtils {

    /**
     * Open a plot on an all loaded data
     * <p/>
     * OTHER, COPY_NUMBER, GENE_EXPRESSION, CHIP, DNA_METHYLATION, TILING_ARRAY, PHASTCON,
     * ALLELE_SPECIFIC_COPY_NUMBER, LOH, MUTATION, RNAI, POOLED_RNAI, CHIP_CHIP, CNV,
     * ALLELE_FREQUENCY, COVERAGE, REPMASK, EXPR
     */
    static HashSet<TrackType> plottableTypes = new HashSet();

    static {
        plottableTypes.add(TrackType.COPY_NUMBER);
        plottableTypes.add(TrackType.GENE_EXPRESSION);
        plottableTypes.add(TrackType.DNA_METHYLATION);
    }

    public static void openPlot(String chr, int start, int end, int zoom) {

        List<Track> tracks = IGV.getInstance().getTrackManager().getAllTracks(false);

        List<String> samples = new ArrayList<String>();
        //Map<String, >

        for (Track t : tracks) {

            if (t instanceof DataTrack) {
                DataTrack dataTrack = (DataTrack) t;
                TrackType type = dataTrack.getTrackType();

                String sample = dataTrack.getSampleKey();

                if (plottableTypes.contains(type)) {
                    double regionScore = 0;
                    int intervalSum = 0;
                    Collection<LocusScore> scores = dataTrack.getSummaryScores(chr, start, end, zoom);
                    for (LocusScore score : scores) {
                        if ((score.getEnd() >= start) && (score.getStart() <= end)) {
                            int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                            float value = score.getScore();
                            regionScore += value * interval;
                            intervalSum += interval;
                        }
                    }
                    if (intervalSum > 0) {
                        regionScore /= regionScore / intervalSum;
                    }

                }
            }
        }

    }
}
