/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

package org.broad.igv.scatterplot;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * User: jrobinso
 * Date: Jan 28, 2010
 *
 * modified by martind to work with base class
 * Feb 05, 2010
 */
 /*
 *  Convenience class to produce test data for IGVScatterlot.
 * */
public class ScatterPlotTestData extends ScatterPlotData {

   // data is maintained in the base class ScatterPlotData

    public ScatterPlotTestData(int sampleCount) {

        super();

        // sample data types (numeric measurements)
        String [] samples = new String[sampleCount];    // test sample names
        double [] cnData = new double[sampleCount];
        double [] exprData = new double[sampleCount];
        double [] methData = new double[sampleCount];

        for(int i=0; i<sampleCount; i++) {
            samples[i] = "Sample " + i;
            cnData[i] = ((double) i / sampleCount) * 4 * (2*Math.random());
            exprData[i] = -2 + ((double) i / sampleCount) * 4 * (2*Math.random());
            methData[i] = 1 - i * Math.random() / sampleCount;
            System.out.println(cnData[i]+ "\t" + exprData[i] + "\t" + methData[i]);
        }

        Map<String, double[]> dataMap = new LinkedHashMap<String, double[]>();
        dataMap.put("Copy Number", cnData);
        dataMap.put("Expression", exprData);
        dataMap.put("Methylation", methData);

        // sample attributes (categorical)
        String [] treated = new String[sampleCount];
        String [] hyperMutated = new String[sampleCount];
        String [] cluster = new String[sampleCount];

        for(int i=0; i<sampleCount; i++) {
            treated[i] = Math.random() > 0.5 ? "AA" : "B";
            if(i%6 == 0)
             treated[i] = "null";
            hyperMutated[i] = Math.random() > 0.9 ? "Y" : "N";
            if(i%7 == 0)
             hyperMutated[i] = "null";

            double classValue =  Math.random();
            if(classValue > .9)
                cluster[i] = "Proneural";
            else if(classValue > .8)
                cluster[i] = "neural";
            else if(classValue > .6)
                cluster[i] = "classical";
            else if(classValue > .4)
                cluster[i] = "mesenchymal";
            else
                cluster[i] = "unknown";
            System.out.println(cnData[i]+ "\t" + exprData[i] + "\t" + methData[i]);
       }

        Map<String, String[]> symbolMap = new LinkedHashMap<String, String[]>();
        symbolMap.put("Treatment", treated);
        symbolMap.put("Hyper mutated", hyperMutated);
        symbolMap.put("Cluster Type", cluster);

        // load the base class ScatterPlotData
        loadData( samples,  symbolMap, dataMap);

    }

    // *********** data access is provided by the base class *************

}
