/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;

public class HexColorConverter
extends ColorConverter {
    protected String getHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public String toString(Object object, ConverterContext converterContext) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer stringBuffer = new StringBuffer("#");
            stringBuffer.append(this.getHexString(color.getRed()));
            stringBuffer.append(this.getHexString(color.getGreen()));
            stringBuffer.append(this.getHexString(color.getBlue()));
            return new String(stringBuffer);
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public Object fromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Color(n);
    }
}

