/*
 * Copyright (c) 2007-2011 by The Broad Institute of MIT and Harvard.  All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL),
 * Version 2.1 which is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR
 * WARRANTES OF ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING,
 * WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, WHETHER
 * OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR RESPECTIVE
 * TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES
 * OF ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES,
 * ECONOMIC DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER
 * THE BROAD OR MIT SHALL BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT
 * SHALL KNOW OF THE POSSIBILITY OF THE FOREGOING.
 */

package org.broad.igv.util.stream;

import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableHTTPStream;
import org.broad.tribble.util.SeekableStream;

import java.io.File;
import java.io.IOException;
import java.net.URL;

/**
 * @author Jim Robinson
 */
public class IGVSeekableStreamFactory {

    public static SeekableStream getStreamFor(String path) throws IOException {

        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);

        } else {
            SeekableStream is = null;
            if (path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:")) {
                boolean useByteRange = HttpUtils.getInstance().useByteRange();
                if (useByteRange) {

                    // Test path
                    long contentLength = HttpUtils.getInstance().getContentLength(new URL(path));

                    is = new SeekableHTTPStream(new IGVUrlHelper(new URL(path)));
                } else {
                    is = new SeekableServiceStream(path);
                }
            } else if (path.toLowerCase().startsWith("ftp:")) {

                
                is = new SeekableFTPStream(new URL(path));
            } else {
                is = new SeekableFileStream(new File(path));
            }
            return is;
        }
    }

}
