/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMSequenceRecord
extends AbstractSAMHeaderRecord
implements Cloneable {
    private String mSequenceName = null;
    private int mSequenceIndex = -1;
    private int mSequenceLength = 0;
    public static final String SEQUENCE_NAME_TAG = "SN";
    public static final String SEQUENCE_LENGTH_TAG = "LN";
    public static final String MD5_TAG = "M5";
    public static final String ASSEMBLY_TAG = "AS";
    public static final String URI_TAG = "UR";
    public static final String SPECIES_TAG = "SP";
    public static final int UNKNOWN_SEQUENCE_LENGTH = 0;
    public static final String RESERVED_MRNM_SEQUENCE_NAME = "=";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("SN", "LN", "AS", "M5", "UR", "SP"));
    private static Pattern SEQUENCE_NAME_SPLITTER = Pattern.compile("\\s");

    public SAMSequenceRecord(String name) {
        this(name, 0);
    }

    public SAMSequenceRecord(String name, int sequenceLength) {
        if (name != null) {
            if (SEQUENCE_NAME_SPLITTER.matcher(name).find()) {
                throw new SAMException("Sequence name contains invalid character: " + name);
            }
            SAMSequenceRecord.validateSequenceName(name);
            this.mSequenceName = name.intern();
        }
        this.mSequenceLength = sequenceLength;
    }

    public String getSequenceName() {
        return this.mSequenceName;
    }

    private void setSequenceName(String name) {
        this.mSequenceName = name != null ? name.intern() : null;
    }

    public int getSequenceLength() {
        return this.mSequenceLength;
    }

    public void setSequenceLength(int value) {
        this.mSequenceLength = value;
    }

    public String getAssembly() {
        return this.getAttribute(ASSEMBLY_TAG);
    }

    public void setAssembly(String value) {
        this.setAttribute(ASSEMBLY_TAG, value);
    }

    public String getSpecies() {
        return this.getAttribute(SPECIES_TAG);
    }

    public void setSpecies(String value) {
        this.setAttribute(SPECIES_TAG, value);
    }

    public int getSequenceIndex() {
        return this.mSequenceIndex;
    }

    void setSequenceIndex(int value) {
        this.mSequenceIndex = value;
    }

    public boolean isSameSequence(SAMSequenceRecord that) {
        BigInteger thatMd5;
        BigInteger thisMd5;
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != 0 && that.mSequenceLength != 0 && this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        return !(this.getAttribute(MD5_TAG) != null && that.getAttribute(MD5_TAG) != null ? !(thisMd5 = new BigInteger(this.getAttribute(MD5_TAG), 16)).equals(thatMd5 = new BigInteger(that.getAttribute(MD5_TAG), 16)) : this.mSequenceName != that.mSequenceName);
    }

    private URI makeURI(String s) throws URISyntaxException {
        URI uri = new URI(s);
        if (uri.getScheme() == null) {
            uri = new URI("file", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMSequenceRecord)) {
            return false;
        }
        SAMSequenceRecord that = (SAMSequenceRecord)o;
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (!this.attributesEqual(that)) {
            return false;
        }
        return this.mSequenceName == that.mSequenceName;
    }

    public int hashCode() {
        return this.mSequenceName != null ? this.mSequenceName.hashCode() : 0;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public final SAMSequenceRecord clone() {
        SAMSequenceRecord ret = new SAMSequenceRecord(this.mSequenceName, this.mSequenceLength);
        ret.mSequenceIndex = this.mSequenceIndex;
        for (Map.Entry<String, String> entry : this.getAttributes()) {
            ret.setAttribute(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String truncateSequenceName(String sequenceName) {
        return SEQUENCE_NAME_SPLITTER.split(sequenceName, 2)[0];
    }

    public static void validateSequenceName(String name) {
        if (RESERVED_MRNM_SEQUENCE_NAME.equals(name)) {
            throw new SAMException("'=' is not a valid sequence name");
        }
    }
}

