/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.readers.AsciiQueryReader;
import org.broad.tribble.readers.QueryReader;
import org.broad.tribble.readers.TabixReader;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.CloseableTribbleIterator;
import org.broad.tribble.util.LineReader;
import org.broad.tribble.util.ParsingUtils;

public class BasicFeatureReader<T extends Feature>
implements FeatureReader {
    private static Logger log = Logger.getLogger(BasicFeatureReader.class);
    String path;
    private final QueryReader querySource;
    private final FeatureCodec codec;
    private final Object header;

    public BasicFeatureReader(String featureFile, FeatureCodec codec) throws IOException {
        this.path = featureFile;
        if (featureFile.endsWith(".gz") && TabixReader.isTabix(featureFile)) {
            this.querySource = new TabixReader(featureFile);
        } else {
            String indexFile = featureFile + ".idx";
            this.querySource = new AsciiQueryReader(featureFile, indexFile);
        }
        this.codec = codec;
        this.header = this.readHeader();
    }

    public BasicFeatureReader(String featureFile, Index indexInstance, FeatureCodec codec) throws IOException {
        this.path = featureFile;
        this.codec = codec;
        this.querySource = new AsciiQueryReader(featureFile, indexInstance);
        this.header = this.readHeader();
    }

    public BasicFeatureReader(String featureFile, String indexFile, FeatureCodec codec) throws IOException {
        this.path = featureFile;
        this.querySource = new AsciiQueryReader(featureFile, indexFile);
        this.codec = codec;
        this.header = this.readHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readHeader() throws IOException {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.path);
            Object object = this.codec.readHeader(reader);
            return object;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Object getHeader() {
        return this.header;
    }

    @Override
    public void close() throws IOException {
        if (this.querySource != null) {
            this.querySource.close();
        }
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        return this.query(chr, start, end, false);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        return new IteratorImpl(this);
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end, boolean contained) throws IOException {
        return new IteratorImpl(this, chr, start, end, contained);
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.querySource.getSequenceNames();
    }

    public static class IteratorImpl<T extends Feature>
    implements CloseableTribbleIterator {
        private static Logger log = Logger.getLogger("IteratorImpl");
        String chr;
        int start;
        int end;
        boolean contained;
        T currentRecord;
        final LineReader reader;
        BasicFeatureReader<T> BasicFeatureReader;

        IteratorImpl(BasicFeatureReader<T> BasicFeatureReader2) throws IOException {
            this.BasicFeatureReader = BasicFeatureReader2;
            this.reader = ((BasicFeatureReader)BasicFeatureReader2).querySource.iterate();
            this.readNextRecord();
        }

        IteratorImpl(BasicFeatureReader<T> BasicFeatureReader2, String sequence, int start, int end, boolean contained) throws IOException {
            this.BasicFeatureReader = BasicFeatureReader2;
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.reader = ((BasicFeatureReader)BasicFeatureReader2).querySource.query(this.chr, start, end);
            this.advanceToFirstRecord();
        }

        private T readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && this.reader != null && (nextLine = this.reader.readLine()) != null) {
                Feature f2 = null;
                f2 = (Feature)((BasicFeatureReader)this.BasicFeatureReader).codec.decode(nextLine);
                if (f2 == null) continue;
                if (this.end > 0 && f2.getStart() > this.end || this.chr != null && !this.chr.equals(f2.getChr())) break;
                if (f2.getEnd() < this.start) continue;
                this.currentRecord = f2;
            }
            return this.currentRecord;
        }

        private void advanceToFirstRecord() throws IOException {
            T record = this.readNextRecord();
            while (!(record == null || !this.currentRecord.getChr().equals(this.chr) || this.contained && this.currentRecord.getStart() >= this.start || !this.contained && this.currentRecord.getEnd() >= this.start)) {
                if (this.currentRecord.getStart() > this.end) {
                    this.currentRecord = null;
                    break;
                }
                record = this.readNextRecord();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null) {
                return this.currentRecord != null;
            }
            return this.currentRecord != null && this.chr.equals(this.currentRecord.getChr()) && (this.contained ? this.currentRecord.getEnd() <= this.end : this.currentRecord.getStart() <= this.end);
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e2) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e2);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }
    }
}

