/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.readers.BasicFeatureReader;
import org.broad.tribble.readers.QueryReader;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.LineReader;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class AsciiQueryReader
implements QueryReader {
    private static Logger log = Logger.getLogger(BasicFeatureReader.class);
    protected SeekableStream seekableStream;
    protected Index index;

    public AsciiQueryReader(String featureFile, String indexFile) throws IOException {
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = IndexFactory.loadIndex(indexFile);
    }

    public AsciiQueryReader(String featureFile) throws IOException {
        String indexFile = featureFile + ".idx";
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = IndexFactory.loadIndex(indexFile);
    }

    public AsciiQueryReader(String featureFile, Index indexInstance) throws IOException {
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = indexInstance;
    }

    @Override
    public void close() throws IOException {
        if (this.seekableStream != null) {
            this.seekableStream.close();
        }
    }

    @Override
    public LineReader iterate() throws IOException {
        this.seekableStream.seek(0L);
        return new AsciiLineReader(this.seekableStream);
    }

    @Override
    public LineReader query(String chr, int start, int end) {
        return new IndexedReader(chr, start, end);
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.index.getSequenceNames();
    }

    public class IndexedReader
    implements LineReader {
        String chr;
        int start;
        int end;
        AsciiLineReader reader;
        List<Block> blocks;

        public IndexedReader() {
            this.reader = new AsciiLineReader(AsciiQueryReader.this.seekableStream);
        }

        public IndexedReader(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.init();
        }

        @Override
        public String readLine() throws IOException {
            return this.reader == null ? null : this.reader.readLine();
        }

        @Override
        public void close() {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        private void init() {
            if (AsciiQueryReader.this.index == null) {
                throw new UnsupportedOperationException("Files must be indexed to support query methods");
            }
            this.blocks = AsciiQueryReader.this.index.getBlocks(this.chr, this.start, this.end);
            if (this.blocks == null || this.blocks.size() == 0) {
                this.reader = null;
            } else {
                Block firstBlock = this.blocks.get(0);
                Block lastBlock = this.blocks.get(this.blocks.size() - 1);
                try {
                    AsciiQueryReader.this.seekableStream.seek(firstBlock.getStartPosition());
                    this.reader = new AsciiLineReader(AsciiQueryReader.this.seekableStream);
                }
                catch (IOException ex) {
                    log.error("Error seeking to position: " + firstBlock.getStartPosition(), ex);
                }
            }
        }
    }
}

