/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.UnsortedFileException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.LittleEndianOutputStream;

public class LinearIndexCreator
extends IndexCreator {
    private static Logger log = Logger.getLogger(LinearIndexCreator.class);
    static int DEFAULT_BINWIDTH = 16000;
    private int binWidth = DEFAULT_BINWIDTH;
    private boolean verbose = true;

    public LinearIndexCreator(File featureFile, FeatureCodec codec) {
        super(featureFile, codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index createIndex() throws IOException {
        long filePosition;
        LinearIndex featureIndex = new LinearIndex(this.binWidth, this.featureFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(this.featureFile);
        AsciiLineReader reader = new AsciiLineReader(is);
        this.codec.readHeader(reader);
        long fileLength = this.featureFile.length();
        long progressIncrement = fileLength / 100L;
        long currentFilePosition = 0L;
        String lastChr = null;
        int lastStart = 0;
        int lastBinNumber = 0;
        int lastBinStart = -1;
        int longestFeature = 0;
        int progressCounter = 1;
        int lineNumber = 0;
        String nextLine = "";
        Feature f2 = null;
        do {
            ++lineNumber;
            filePosition = reader.getPosition();
        } while ((nextLine = reader.readLine()) != null && (f2 = this.codec.decodeLoc(nextLine)) == null);
        if (f2 != null) {
            lastChr = f2.getChr();
            lastBinStart = f2.getStart();
        }
        currentFilePosition = reader.getPosition();
        while ((nextLine = reader.readLine()) != null) {
            ++lineNumber;
            f2 = this.codec.decodeLoc(nextLine);
            if (f2 == null) continue;
            String chr = f2.getChr();
            if (!chr.equals(lastChr)) {
                int bytesCount = (int)(currentFilePosition - filePosition);
                featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                lastBinStart = f2.getStart();
                filePosition = currentFilePosition;
                lastBinNumber = 0;
                lastStart = 0;
                longestFeature = 0;
                lastChr = chr;
            } else {
                int start = f2.getStart();
                longestFeature = Math.max(longestFeature, f2.getEnd() - start);
                if (start < lastStart) {
                    throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                }
                lastStart = start;
                int binNumber = start / this.binWidth;
                if (binNumber > lastBinNumber) {
                    int cnt = 0;
                    for (cnt = 0; cnt < lastBinStart / this.binWidth - lastBinNumber; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber += cnt;
                    int bytesCount = (int)(currentFilePosition - filePosition);
                    featureIndex.add(lastChr, filePosition, bytesCount, longestFeature);
                    lastBinStart = f2.getStart();
                    filePosition = currentFilePosition;
                    for (cnt = 0; cnt < binNumber - lastBinNumber - 1; ++cnt) {
                        featureIndex.add(lastChr, filePosition, 0, longestFeature);
                    }
                    lastBinNumber = binNumber;
                }
            }
            if ((currentFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter);
            ++progressCounter;
        }
        int byteCount = (int)(reader.getPosition() - filePosition);
        featureIndex.add(lastChr, filePosition, byteCount, longestFeature);
        is.close();
        if (this.idxFile != null) {
            FilterOutputStream stream = null;
            try {
                stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.idxFile)));
                featureIndex.write((LittleEndianOutputStream)stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return featureIndex;
    }

    private void updateProgress(int progressCounter) {
        if (this.verbose) {
            System.out.println("Progress: " + progressCounter + "%");
        }
    }

    public int getBinWidth() {
        return this.binWidth;
    }

    public void setBinWidth(int binWidth) {
        this.binWidth = binWidth;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

