/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.index.interval.Interval;

public class IntervalTree {
    private static Logger logger = Logger.getLogger(IntervalTree.class);
    Node root;
    Node NIL;
    int size;

    public IntervalTree() {
        this.root = this.NIL = Node.NIL;
        this.size = 0;
    }

    public void insert(Interval interval) {
        Node node = new Node(interval);
        this.insert(node);
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public List<Interval> findOverlapping(Interval interval) {
        logger.debug("Starting search for " + interval);
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> results = new ArrayList<Interval>();
        this.searchAll(interval, this.root(), results);
        return results;
    }

    public String toString() {
        return this.root().toString();
    }

    private List<Interval> searchAll(Interval interval, Node node, List<Interval> results) {
        System.out.println("Visiting " + node.interval);
        if (node.interval.overlaps(interval)) {
            results.add(node.interval);
        }
        if (!node.left.isNull() && node.left.max >= interval.start) {
            this.searchAll(interval, node.left, results);
        }
        if (!node.right.isNull() && node.right.min <= interval.end) {
            this.searchAll(interval, node.right, results);
        }
        return results;
    }

    public List<Interval> getIntervals() {
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> results = new ArrayList<Interval>(this.size);
        this.getAll(this.root(), results);
        return results;
    }

    private List<Interval> getAll(Node node, List<Interval> results) {
        results.add(node.interval);
        if (!node.left.isNull()) {
            this.getAll(node.left, results);
        }
        if (!node.right.isNull()) {
            this.getAll(node.right, results);
        }
        return results;
    }

    private int getRealMax(Node node) {
        if (node.isNull()) {
            return Integer.MIN_VALUE;
        }
        int leftMax = this.getRealMax(node.left);
        int rightMax = this.getRealMax(node.right);
        int nodeHigh = node.interval.end;
        int max1 = leftMax > rightMax ? leftMax : rightMax;
        return max1 > nodeHigh ? max1 : nodeHigh;
    }

    private int getRealMin(Node node) {
        if (node.isNull()) {
            return Integer.MAX_VALUE;
        }
        int leftMin = this.getRealMin(node.left);
        int rightMin = this.getRealMin(node.right);
        int nodeLow = node.interval.start;
        int min1 = leftMin < rightMin ? leftMin : rightMin;
        return min1 < nodeLow ? min1 : nodeLow;
    }

    private void insert(Node x) {
        assert (x != null);
        assert (!x.isNull());
        this.treeInsert(x);
        x.color = Node.RED;
        while (x != this.root && x.parent.color == Node.RED) {
            Node y;
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (y.color == Node.RED) {
                    x.parent.color = Node.BLACK;
                    y.color = Node.BLACK;
                    x.parent.parent.color = Node.RED;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    this.leftRotate(x);
                }
                x.parent.color = Node.BLACK;
                x.parent.parent.color = Node.RED;
                this.rightRotate(x.parent.parent);
                continue;
            }
            y = x.parent.parent.left;
            if (y.color == Node.RED) {
                x.parent.color = Node.BLACK;
                y.color = Node.BLACK;
                x.parent.parent.color = Node.RED;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                this.rightRotate(x);
            }
            x.parent.color = Node.BLACK;
            x.parent.parent.color = Node.RED;
            this.leftRotate(x.parent.parent);
        }
        this.root.color = Node.BLACK;
    }

    private Node root() {
        return this.root;
    }

    private void leftRotate(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.NIL) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == this.NIL) {
            this.root = y;
        } else if (x.parent.left == x) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
        this.applyUpdate(x);
    }

    private void rightRotate(Node x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.NIL) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == this.NIL) {
            this.root = y;
        } else if (x.parent.right == x) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
        this.applyUpdate(x);
    }

    private void treeInsert(Node x) {
        Node node = this.root;
        Node y = this.NIL;
        while (node != this.NIL) {
            y = node;
            if (x.interval.start <= node.interval.start) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        x.parent = y;
        if (y == this.NIL) {
            this.root = x;
            x.left = x.right = this.NIL;
        } else if (x.interval.start <= y.interval.start) {
            y.left = x;
        } else {
            y.right = x;
        }
        this.applyUpdate(x);
    }

    private void applyUpdate(Node node) {
        while (!node.isNull()) {
            this.update(node);
            node = node.parent;
        }
    }

    private void update(Node node) {
        node.max = Math.max(Math.max(node.left.max, node.right.max), node.interval.end);
        node.min = Math.min(Math.min(node.left.min, node.right.min), node.interval.start);
    }

    public int size() {
        return this._size(this.root);
    }

    private int _size(Node node) {
        if (node.isNull()) {
            return 0;
        }
        return 1 + this._size(node.left) + this._size(node.right);
    }

    private boolean allRedNodesFollowConstraints(Node node) {
        if (node.isNull()) {
            return true;
        }
        if (node.color == Node.BLACK) {
            return this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
        }
        return node.left.color == Node.BLACK && node.right.color == Node.BLACK && this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
    }

    private boolean isBalancedBlackHeight(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.blackHeight(node.left) == this.blackHeight(node.right) && this.isBalancedBlackHeight(node.left) && this.isBalancedBlackHeight(node.right);
    }

    private int blackHeight(Node node) {
        if (node.isNull()) {
            return 0;
        }
        int leftBlackHeight = this.blackHeight(node.left);
        if (node.color == Node.BLACK) {
            return leftBlackHeight + 1;
        }
        return leftBlackHeight;
    }

    public boolean isValid() {
        if (this.root.color != Node.BLACK) {
            logger.warn("root color is wrong");
            return false;
        }
        if (this.NIL.color != Node.BLACK) {
            logger.warn("NIL color is wrong");
            return false;
        }
        if (!this.allRedNodesFollowConstraints(this.root)) {
            logger.warn("red node doesn't follow constraints");
            return false;
        }
        if (!this.isBalancedBlackHeight(this.root)) {
            logger.warn("black height unbalanced");
            return false;
        }
        return this.hasCorrectMaxFields(this.root) && this.hasCorrectMinFields(this.root);
    }

    private boolean hasCorrectMaxFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMax(node) == node.max && this.hasCorrectMaxFields(node.left) && this.hasCorrectMaxFields(node.right);
    }

    private boolean hasCorrectMinFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMin(node) == node.min && this.hasCorrectMinFields(node.left) && this.hasCorrectMinFields(node.right);
    }

    static class Node {
        public static boolean BLACK = false;
        public static boolean RED = true;
        Interval interval;
        int min;
        int max = Integer.MIN_VALUE;
        Node left;
        Node right;
        boolean color;
        Node parent;
        static Node NIL = new Node();

        private Node() {
            this.min = Integer.MAX_VALUE;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeInt(this.interval.start);
            dos.writeInt(this.interval.end);
            dos.writeInt(this.min);
            dos.writeInt(this.max);
        }

        public Node(Interval interval) {
            this();
            this.parent = NIL;
            this.left = NIL;
            this.right = NIL;
            this.interval = interval;
            this.color = RED;
        }

        public boolean isNull() {
            return this == NIL;
        }

        public String toString() {
            if (this == NIL) {
                return "nil";
            }
            StringBuffer buf = new StringBuffer();
            this._toString(buf);
            return buf.toString();
        }

        public void _toString(StringBuffer buf) {
            if (this == NIL) {
                buf.append("nil");
                return;
            }
            buf.append(this.interval + " -> " + this.left.interval + ", " + this.right.interval);
            buf.append("\n");
            this.left._toString(buf);
            this.right._toString(buf);
        }

        static {
            Node.NIL.color = BLACK;
            Node.NIL.parent = NIL;
            Node.NIL.left = NIL;
            Node.NIL.right = NIL;
        }
    }
}

