/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class IndexFactory {
    private static Logger log = Logger.getLogger(IndexFactory.class);
    public static final int LINEAR = 1;
    public static final int INTERVAL_TREE = 2;

    public static Index loadIndex(String indexFile) {
        Index idx = null;
        SeekableStream is = null;
        try {
            is = SeekableStreamFactory.getStreamFor(indexFile);
            LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(is));
            int magicNumber = dis.readInt();
            int type = dis.readInt();
            Class indexClass = IndexFactory.getIndexClass(type);
            idx = (Index)indexClass.newInstance();
            idx.read(dis);
        }
        catch (Exception ex) {
            log.error("Error reading index file: " + indexFile, ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    log.error("Error closing indexFile: " + indexFile, e2);
                }
            }
        }
        return idx;
    }

    private static Class getIndexClass(int type) {
        switch (type) {
            case 1: {
                return LinearIndex.class;
            }
            case 2: {
                return IntervalTreeIndex.class;
            }
        }
        throw new RuntimeException("Unrecognized type flag in index file");
    }
}

