/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.ScatterplotRenderer;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;

public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);

    public static BufferedReader openBufferedReader(String pathOrUrl) throws FileNotFoundException, IOException {
        BufferedReader reader = null;
        if (pathOrUrl.startsWith("http:") || pathOrUrl.startsWith("https:") || pathOrUrl.startsWith("file:")) {
            URL url = new URL(pathOrUrl);
            reader = new BufferedReader(new InputStreamReader(IGVHttpUtils.openConnectionStream(url)));
        } else {
            File file = new File(pathOrUrl);
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                GZIPInputStream in = new GZIPInputStream(fileInput);
                reader = new BufferedReader(new InputStreamReader(in));
            } else {
                reader = new BufferedReader(new InputStreamReader(fileInput));
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int estimateLineCount(String filename) {
        AsciiLineReader reader = null;
        try {
            int nLines;
            String nextLine;
            long fileLength = 0L;
            if (filename.startsWith("http:") || filename.startsWith("https:")) {
                URL url = new URL(filename);
                fileLength = Long.parseLong(IGVHttpUtils.getHeaderField(url, "Content-length"));
            } else {
                fileLength = new File(filename).length();
            }
            reader = ParsingUtils.openAsciiReader(new ResourceLocator(filename));
            int lines = 0;
            int nSkip = 10;
            while (nSkip-- > 0 && reader.readLine() != null) {
            }
            long startPos = reader.getPosition();
            while ((nextLine = reader.readLine()) != null & lines < 100) {
                ++lines;
            }
            if (lines == 0) {
                int n2 = 1000;
                return n2;
            }
            double bytesPerLine = (reader.getPosition() - startPos) / (long)lines;
            int n3 = nLines = (int)((double)fileLength / bytesPerLine);
            return n3;
        }
        catch (Exception e2) {
            log.error("Error estimating line count", e2);
            int n4 = 1000;
            return n4;
        }
        finally {
            reader.close();
        }
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(ResourceLocator locator) throws IOException {
        if (locator.getServerURL() != null) {
            URL url = new URL(locator.getServerURL() + "?method=getContents&file=" + locator.getPath());
            InputStream is = IGVHttpUtils.openConnectionStream(url);
            try {
                return new GZIPInputStream(is);
            }
            catch (Exception ex) {
                log.error("Error with gzip stream", ex);
                throw new RuntimeException("There was a server error loading file: " + locator.getTrackName() + ". Please report to igv-help@broadinstitute.org");
            }
        }
        InputStream inputStream = null;
        if (locator.getPath().startsWith("http:") || locator.getPath().startsWith("https:") || locator.getPath().startsWith("ftp:") || locator.getPath().startsWith("file:")) {
            URL url = new URL(locator.getPath());
            inputStream = IGVHttpUtils.openConnectionStream(url);
        } else {
            File file = new File(locator.getPath());
            inputStream = new FileInputStream(file);
        }
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static int split(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        int end;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int tabEnd = aString.indexOf(9);
        int spaceEnd = aString.indexOf(32);
        int n2 = tabEnd < 0 ? spaceEnd : (end = spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            for (start = end + 1; start < aString.length() && aString.charAt(start) == ' '; ++start) {
            }
            tabEnd = aString.indexOf(9, start);
            spaceEnd = aString.indexOf(32, start);
            end = tabEnd < 0 ? spaceEnd : (spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start).trim();
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceString(String str, String rplString, File ifile, File ofile) throws IOException {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("##")) continue;
                pw.println(nextLine.replace(str, rplString));
            }
        }
        finally {
            pw.close();
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropLinesContaining(String str, File ifile, File ofile) throws IOException {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.contains(str)) continue;
                pw.println(nextLine);
            }
        }
        finally {
            pw.close();
            br.close();
        }
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing numer in line: " + nextLine);
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static void computeReadingShifts(Feature gene) {
        List<Exon> exons = gene.getExons();
        if (exons.size() == 0) {
            return;
        }
        int startIndex = gene.getStrand() == Strand.POSITIVE ? 0 : exons.size() - 1;
        int endIndex = gene.getStrand() == Strand.POSITIVE ? exons.size() : -1;
        int increment = gene.getStrand() == Strand.POSITIVE ? 1 : -1;
        int cds = 0;
        int exonNumber = 1;
        for (int i2 = startIndex; i2 != endIndex; i2 += increment) {
            Exon exon = exons.get(i2);
            exon.setNumber(exonNumber);
            int modCds = cds % 3;
            int phase = modCds == 0 ? 0 : 3 - modCds;
            exon.setPhase(phase);
            cds += exon.getCodingLength();
            ++exonNumber;
        }
    }

    public static boolean parseTrackLine(String nextLine, TrackProperties trackProperties) throws NumberFormatException {
        boolean foundProperties = false;
        try {
            List<String> tokens = StringUtils.breakQuotedString(nextLine, ' ');
            for (String pair : tokens) {
                List<String> kv = StringUtils.breakQuotedString(pair, '=');
                if (kv.size() != 2) continue;
                foundProperties = true;
                String key = kv.get(0).toLowerCase().trim();
                String value = kv.get(1).replaceAll("\"", "");
                if (key.equals("coords")) {
                    if (value.equals("0")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ZERO);
                    } else if (value.equals("1")) {
                        trackProperties.setBaseCoord(TrackProperties.BaseCoord.ONE);
                    }
                }
                if (key.equals("name")) {
                    trackProperties.setName(value);
                    continue;
                }
                if (key.equals("description")) {
                    trackProperties.setDescription(value);
                    continue;
                }
                if (key.equals("itemrgb")) {
                    trackProperties.setItemRGB(value.toLowerCase().equals("on"));
                    continue;
                }
                if (key.equals("usescore")) {
                    trackProperties.setUseScore(value.equals("1"));
                    continue;
                }
                if (key.equals("color")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setColor(color);
                    continue;
                }
                if (key.equals("altcolor")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setAltColor(color);
                    continue;
                }
                if (key.equals("midcolor")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setMidColor(color);
                    continue;
                }
                if (key.equals("autoscale")) {
                    boolean autoscale = value.equals("on");
                    trackProperties.setAutoScale(autoscale);
                    continue;
                }
                if (key.equals("maxheightpixels")) {
                    String[] maxDefMin = value.split(":");
                    trackProperties.setHeight(Integer.parseInt(maxDefMin[0].trim()));
                    trackProperties.setMinHeight(Integer.parseInt(maxDefMin[1].trim()));
                    continue;
                }
                if (key.equals("url")) {
                    trackProperties.setUrl(value);
                    continue;
                }
                if (key.equals("graphtype")) {
                    if (value.equals("bar")) {
                        trackProperties.setRendererClass(BarChartRenderer.class);
                        continue;
                    }
                    if (value.equals("points")) {
                        trackProperties.setRendererClass(ScatterplotRenderer.class);
                        continue;
                    }
                    if (value.equals("line")) {
                        trackProperties.setRendererClass(LineplotRenderer.class);
                        continue;
                    }
                    if (!value.equals("heatmap")) continue;
                    trackProperties.setRendererClass(HeatmapRenderer.class);
                    continue;
                }
                if (key.toLowerCase().equals("viewlimits")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float min = Float.parseFloat(limits[0].trim());
                        float max = Float.parseFloat(limits[1].trim());
                        trackProperties.setMinValue(min);
                        trackProperties.setMaxValue(max);
                    }
                    catch (NumberFormatException e2) {
                        log.error("viewLimits values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("midrange")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    try {
                        float from = Float.parseFloat(limits[0].trim());
                        float to = Float.parseFloat(limits[1].trim());
                        trackProperties.setNeutralFromValue(from);
                        trackProperties.setNeutralToValue(to);
                    }
                    catch (NumberFormatException e3) {
                        log.error("midrange values must be numeric: " + value);
                    }
                    continue;
                }
                if (key.equals("ylinemark")) {
                    try {
                        float midValue = Float.parseFloat(value);
                        trackProperties.setMidValue(midValue);
                    }
                    catch (NumberFormatException e4) {
                        log.error("Number format exception in track line (ylinemark): " + nextLine);
                    }
                    continue;
                }
                if (key.equals("ylineonoff")) {
                    trackProperties.setDrawMidValue(value.equals("on"));
                    continue;
                }
                if (key.equals("windowingfunction")) {
                    if (value.equals("maximum")) {
                        trackProperties.setWindowingFunction(WindowFunction.max);
                        continue;
                    }
                    if (value.equals("minimum")) {
                        trackProperties.setWindowingFunction(WindowFunction.min);
                        continue;
                    }
                    if (value.equals("mean")) {
                        trackProperties.setWindowingFunction(WindowFunction.mean);
                        continue;
                    }
                    if (value.equals("median")) {
                        trackProperties.setWindowingFunction(WindowFunction.median);
                        continue;
                    }
                    if (value.equals("percentile10")) {
                        trackProperties.setWindowingFunction(WindowFunction.percentile10);
                        continue;
                    }
                    if (!value.equals("percentile90")) continue;
                    trackProperties.setWindowingFunction(WindowFunction.percentile90);
                    continue;
                }
                if (key.equals("maxfeaturewindow") || key.equals("featurevisibilitywindow")) {
                    try {
                        int windowSize = Integer.parseInt(value);
                        trackProperties.setFeatureVisibilityWindow(windowSize);
                    }
                    catch (NumberFormatException e5) {
                        log.error("featureVisibilityWindow must be numeric: " + nextLine);
                    }
                    continue;
                }
                if (key.equals("visibilitywindow")) {
                    try {
                        int windowSize = Integer.parseInt(value) * 1000;
                        trackProperties.setFeatureVisibilityWindow(windowSize);
                    }
                    catch (NumberFormatException e6) {
                        log.error("featureVisibilityWindow must be an integer: " + nextLine);
                    }
                    continue;
                }
                if (!key.equals("scaletype") || !value.equals("log")) continue;
                trackProperties.setLogScale(true);
            }
        }
        catch (Exception exception) {
            MessageUtils.showMessage("Error parsing track line: " + nextLine + " (" + exception.getMessage() + ")");
        }
        return foundProperties;
    }

    public static boolean pathExists(String covPath) {
        try {
            return new File(covPath).exists() || (covPath.startsWith("http:") || covPath.startsWith("https:")) && IGVHttpUtils.resourceAvailable(new URL(covPath));
        }
        catch (MalformedURLException e2) {
            return false;
        }
    }
}

