/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGVMainFrame;

public class MessageUtils {
    private static Logger log = Logger.getLogger(MessageUtils.class);

    public static void showMessage(String message) {
        if (Globals.isHeadless() || Globals.isSuppress()) {
            log.info(message);
        } else {
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), message);
        }
    }

    public static boolean confirm(String message) {
        int opt = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), message, "Continue Loading", 0);
        return opt == 0;
    }

    public static void showAndLogErrorMessage(Component component, String message, Logger log, Exception e2) {
        if (log != null) {
            if (e2 != null) {
                log.error(message, e2);
            } else {
                log.error(message);
            }
        }
        JOptionPane.showMessageDialog(component, message);
    }

    public static void showAndLogErrorMessage(Component component, String message, Logger log) {
        MessageUtils.showAndLogErrorMessage(component, message, log, null);
    }

    public static String showInputDialog(String message, String defaultValue) {
        String val = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), message, defaultValue);
        return val;
    }

    public static String showInputDialog(String message) {
        String val = JOptionPane.showInputDialog(IGVMainFrame.getInstance(), (Object)message);
        return val;
    }
}

