/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import com.jidesoft.action.CommandBar;
import java.awt.Color;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicBorders;
import org.broad.igv.ui.action.MenuAction;

public class MenuAndToolbarUtils {
    public static JMenuBar createMenuBar(List<AbstractButton> menus) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        menuBar.setBorderPainted(true);
        for (AbstractButton menu : menus) {
            menuBar.add(menu);
        }
        return menuBar;
    }

    public static CommandBar createToolBar(List<JComponent> actionComponent) {
        CommandBar toolBar = new CommandBar();
        if (actionComponent != null) {
            for (JComponent action : actionComponent) {
                toolBar.add(action);
            }
        }
        return toolBar;
    }

    public static JMenu createMenu(List<JComponent> menuItems, MenuAction action) {
        JMenu menu = new JMenu();
        menu.setAction(action);
        for (JComponent menuItem : menuItems) {
            menu.add(menuItem);
        }
        String text = action.getToolTipText();
        if (text != null) {
            menu.setToolTipText(text);
        }
        return menu;
    }

    public static JMenuItem createMenuItem(MenuAction menuItemAction) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.setAction(menuItemAction);
        String text = menuItemAction.getToolTipText();
        if (text != null) {
            menuItem.setToolTipText(text);
        }
        return menuItem;
    }

    public static JCheckBoxMenuItem createMenuItem(MenuAction menuItemAction, boolean isSelected) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isSelected);
        menuItem.setAction(menuItemAction);
        String text = menuItemAction.getToolTipText();
        if (text != null) {
            menuItem.setToolTipText(text);
        }
        return menuItem;
    }
}

