/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.GenericUtilities;
import org.jdesktop.layout.GroupLayout;

public class FileChooserDialog
extends JDialog {
    private File lastProgramaticallySelectedFile;
    private File previousFile;
    private File lastDirectory;
    private boolean isCanceled = true;
    private boolean autoRememberLastFile = false;
    private boolean autoRememberLastDirectory = false;
    private boolean isDisposableOnOk = false;
    private boolean isDisposableOnCancel = false;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    private JFileChooser fileChooser;

    public FileChooserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(725, 475);
        this.setLocationRelativeTo(parent);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                if (e2.getPropertyName().equals("fileFilterChanged")) {
                    File selectedFile = FileChooserDialog.this.lastProgramaticallySelectedFile;
                    if (selectedFile == null) {
                        return;
                    }
                    Object filter = e2.getNewValue();
                    if (filter instanceof GenericUtilities.SnapshotFileFilter) {
                        GenericUtilities.SnapshotFileFilter snapshotFilter = (GenericUtilities.SnapshotFileFilter)filter;
                        File newFile = FileChooserDialog.this.changeFileExtension(selectedFile, snapshotFilter.getExtension());
                        FileChooserDialog.this.fileChooser.setSelectedFile(newFile);
                    }
                }
            }
        });
    }

    @Override
    public void setVisible(boolean value) {
        if (!UIConstants.IS_MAC) {
            this.fileChooser.rescanCurrentDirectory();
        }
        super.setVisible(value);
    }

    private File changeFileExtension(File file, String newExtension) {
        if (file == null || file.isDirectory() || newExtension == null || newExtension.trim().equals("") || newExtension.trim().equals(".")) {
            return file;
        }
        String filePath = file.getAbsolutePath();
        int index = filePath.lastIndexOf(".");
        if (index > 0) {
            filePath = filePath.substring(0, index);
        }
        return new File(filePath + newExtension);
    }

    public void setFileSelectionMode(int mode) {
        this.fileChooser.setFileSelectionMode(mode);
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public File[] getSelectedFiles() {
        return this.fileChooser.getSelectedFiles();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setMultiSelectionEnabled(boolean isEnabled) {
        this.fileChooser.setMultiSelectionEnabled(true);
    }

    public void setSelectedFile(File file) {
        this.fileChooser.setSelectedFile(file);
        this.lastProgramaticallySelectedFile = file;
        if (this.autoRememberLastFile) {
            this.setPreviousFile(file);
        }
    }

    public void setPreviousFile(File lastFile) {
        this.previousFile = lastFile;
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
        if (this.autoRememberLastDirectory) {
            this.setLastDirectory(file);
        }
        this.fileChooser.rescanCurrentDirectory();
    }

    public void setLastDirectory(File lastDirectory) {
        this.lastDirectory = lastDirectory;
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.setDefaultCloseOperation(2);
        this.fileChooser.setApproveButtonText("Ok");
        this.fileChooser.setDialogTitle("Select a file or folder");
        this.fileChooser.setDialogType(2);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChooserDialog.this.fileChooserActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.fileChooser, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.fileChooser, -1, 402, Short.MAX_VALUE)));
        this.pack();
    }

    private void fileChooserActionPerformed(ActionEvent evt) {
        final String action = evt.getActionCommand();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (action.equals("CancelSelection")) {
                    FileChooserDialog.this.isCanceled = true;
                    FileChooserDialog.this.setVisible(false);
                    if (FileChooserDialog.this.isDisposableOnCancel) {
                        FileChooserDialog.this.dispose();
                    }
                } else if (action.equals("ApproveSelection")) {
                    FileChooserDialog.this.isCanceled = false;
                    FileChooserDialog.this.setVisible(false);
                    if (FileChooserDialog.this.isDisposableOnOk) {
                        FileChooserDialog.this.dispose();
                    }
                }
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileChooserDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

