/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.TrackPanel;

public abstract class TrackPanelComponent
extends JPanel {
    private static Logger log = Logger.getLogger(TrackPanelComponent.class);
    List<MouseableRegion> trackRegions;
    private TrackPanel trackPanel;
    int searchIdx = 0;

    public TrackPanelComponent(TrackPanel trackPanel) {
        this.trackPanel = trackPanel;
        this.setFocusable(true);
        this.trackRegions = new ArrayList<MouseableRegion>();
    }

    public TrackPanel getTrackSetView() {
        if (this.trackPanel == null) {
            this.trackPanel = (TrackPanel)this.getParent();
        }
        return this.trackPanel;
    }

    public String getTrackSetID() {
        return this.getTrackSetView().getName();
    }

    public int calculateResizeHeight() {
        TrackPanel trackView = this.getTrackSetView();
        if (trackView == null) {
            return 0;
        }
        int viewportHeight = trackView.getViewportHeight();
        if (trackView.hasTracks()) {
            int newHeight = trackView.getPreferredPanelHeight();
            newHeight = newHeight < viewportHeight ? viewportHeight : newHeight;
            return newHeight;
        }
        return viewportHeight;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int adjustedHeight = this.calculateResizeHeight();
        super.setBounds(x, y, width, adjustedHeight);
    }

    @Override
    public void setBounds(Rectangle r) {
        int adjustedHeight = this.calculateResizeHeight();
        super.setBounds(r.x, r.y, r.width, adjustedHeight);
    }

    @Override
    public void setSize(int width, int height) {
        int adjustedHeight = this.calculateResizeHeight();
        super.setSize(width, adjustedHeight);
    }

    @Override
    public void setSize(Dimension d2) {
        int adjustedHeight = this.calculateResizeHeight();
        super.setSize(new Dimension(d2.width, adjustedHeight));
    }

    protected void addMousableRegion(MouseableRegion region) {
        this.trackRegions.add(region);
    }

    protected void removeMousableRegions() {
        this.trackRegions.clear();
    }

    protected List<MouseableRegion> getTrackRegions() {
        return this.trackRegions;
    }

    public boolean scrollTo(String trackName) {
        Track t = this.findNextTrackMatching(trackName);
        if (t != null) {
            IGVMainFrame.getInstance().getTrackManager().clearSelections();
            t.setSelected(true);
            if (this.trackPanel.getScrollPane().getVerticalScrollBar().isShowing()) {
                this.trackPanel.getScrollPane().getVerticalScrollBar().setValue(t.getTop());
            }
            return true;
        }
        return false;
    }

    private synchronized Track findNextTrackMatching(String trackName) {
        Track t;
        int i2;
        List<Track> tracks = this.getAllTracks();
        for (i2 = this.searchIdx = Math.min(this.searchIdx, tracks.size()); i2 < tracks.size(); ++i2) {
            t = tracks.get(i2);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i2 + 1;
            return t;
        }
        for (i2 = 0; i2 < this.searchIdx; ++i2) {
            t = tracks.get(i2);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i2 + 1;
            return t;
        }
        return null;
    }

    public abstract String getPopupMenuTitle(int var1, int var2);

    protected Collection<Track> getSelectedTracks() {
        return IGVMainFrame.getInstance().getTrackManager().getSelectedTracks();
    }

    public List<Track> getAllTracks() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getTracks();
    }

    protected ViewContext getViewContext() {
        return ViewContext.getInstance();
    }

    protected void openPopupMenu(MouseEvent e2) {
        Collection<Track> selectedTracs = this.getSelectedTracks();
        if (selectedTracs.size() == 0) {
            return;
        }
        if (selectedTracs.size() == 1 && selectedTracs.iterator().next().handleClick(e2)) {
            return;
        }
        String title = this.getPopupMenuTitle(e2.getX(), e2.getY());
        JPopupMenu menu = TrackMenuUtils.getPopupMenu(selectedTracs, title, e2);
        menu.show(e2.getComponent(), e2.getX(), e2.getY());
    }

    protected void toggleTrackSelections(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.trackRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            IGVMainFrame.getInstance().getTrackManager().toggleTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected void clearTrackSelections() {
        IGVMainFrame.getInstance().getTrackManager().clearSelections();
    }

    protected void selectTracks(MouseEvent e2) {
        if (log.isDebugEnabled()) {
            log.debug("Enter selectTracks");
        }
        for (MouseableRegion mouseRegion : this.trackRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            IGVMainFrame.getInstance().getTrackManager().setTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected boolean isTrackSelected(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.trackRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            for (Track t : mouseRegion.getTracks()) {
                if (!t.isSelected()) continue;
                return true;
            }
        }
        return false;
    }
}

