/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JidePopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.dnd.AbstractGhostDropManager;
import org.broad.igv.ui.dnd.GhostDropEvent;
import org.broad.igv.ui.dnd.GhostDropListener;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class TrackNamePanel
extends TrackPanelComponent
implements AdjustmentListener {
    private static Logger log = Logger.getLogger(TrackNamePanel.class);
    static List<DropListener> dropListeners = new ArrayList<DropListener>();
    List<GroupExtent> groupExtents = new ArrayList<GroupExtent>();
    BufferedImage dndImage = null;
    TrackGroup selectedGroup = null;
    boolean showGroupNames = true;
    boolean showSampleNamesWhenGrouped = false;

    static void addGhostDropListener(DropListener listener) {
        if (listener != null) {
            dropListeners.add(listener);
        }
    }

    public static void removeDropListenerFor(TrackNamePanel panel) {
        ArrayList<DropListener> removeThese = new ArrayList<DropListener>();
        for (DropListener dl : dropListeners) {
            if (dl.panel != panel) continue;
            removeThese.add(dl);
        }
        dropListeners.removeAll(removeThese);
    }

    public TrackNamePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.init();
    }

    Collection<TrackGroup> getGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    private boolean isGrouped() {
        Collection<TrackGroup> groups = this.getGroups();
        return groups.size() > 1;
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.removeMousableRegions();
        Collection<TrackGroup> groups = this.getGroups();
        boolean isGrouped = groups.size() > 1;
        Rectangle visibleRect = this.getVisibleRect();
        if (!groups.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)g2.create();
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = (Graphics2D)g2.create();
            greyGraphics.setColor(UIConstants.VERY_LIGHT_GRAY);
            int regionY = 0;
            this.groupExtents.clear();
            for (TrackGroup group : groups) {
                if (!group.isVisible()) continue;
                if (isGrouped) {
                    if (regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                        greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                    }
                    regionY += 10;
                }
                if (group.isDrawBorder() && regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                    g2.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                }
                int y = regionY;
                regionY = this.printTrackNames(group, visibleRect, graphics2D, 0, regionY);
                if (isGrouped) {
                    int h2 = group.getHeight();
                    this.groupExtents.add(new GroupExtent(group, y, y + h2));
                    if (this.showGroupNames) {
                        Rectangle rect = new Rectangle(visibleRect.x, y, visibleRect.width, h2);
                        Rectangle displayableRect = this.getDisplayableRect(rect, visibleRect);
                        group.renderName(graphics2D, displayableRect, group == this.selectedGroup);
                    }
                }
                if (!group.isDrawBorder()) continue;
                g2.drawLine(0, regionY, this.getWidth(), regionY);
            }
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    private int printTrackNames(TrackGroup group, Rectangle visibleRect, Graphics2D graphics2D, int regionX, int regionY) {
        ArrayList<Track> tmp = new ArrayList<Track>(group.getTracks());
        for (Track track : tmp) {
            track.setTop(regionY);
            int trackHeight = track.getHeight();
            if (!track.isVisible()) continue;
            if (regionY + trackHeight >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                int width = this.getWidth();
                int height = track.getHeight();
                Rectangle region = new Rectangle(regionX, regionY, width, height);
                this.addMousableRegion(new MouseableRegion(region, track));
                if (!this.isGrouped() || this.showSampleNamesWhenGrouped) {
                    Rectangle rect = new Rectangle(regionX, regionY, width, height);
                    track.renderName(graphics2D, rect, visibleRect);
                }
            }
            regionY += trackHeight;
        }
        return regionY;
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setBackground(new Color(255, 255, 255));
        GroupLayout dataTrackNamePanelLayout = new GroupLayout(this);
        this.setLayout(dataTrackNamePanelLayout);
        dataTrackNamePanelLayout.setHorizontalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 148, Short.MAX_VALUE));
        dataTrackNamePanelLayout.setVerticalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 528, Short.MAX_VALUE));
        NamePanelMouseAdapter mouseAdapter = new NamePanelMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        DropListener dndListener = new DropListener(this);
        TrackNamePanel.addGhostDropListener(dndListener);
    }

    @Override
    protected void openPopupMenu(MouseEvent e2) {
        Collection<Track> selectedTracs = this.getSelectedTracks();
        String title = this.getPopupMenuTitle(0, 0);
        JidePopupMenu menu = TrackMenuUtils.getEmptyPopup(title);
        if (this.isGrouped()) {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show group names");
            item.setSelected(this.showGroupNames);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TrackNamePanel.this.showGroupNames = item.isSelected();
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.repaint();
                }
            });
            menu.add(item);
            final JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Show sample names");
            item2.setSelected(this.showSampleNamesWhenGrouped);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TrackNamePanel.this.showSampleNamesWhenGrouped = item2.isSelected();
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.repaint();
                }
            });
            menu.add(item2);
            menu.addSeparator();
        }
        TrackMenuUtils.addStandardItems(menu, selectedTracs, e2);
        ((JPopupMenu)menu).show(e2.getComponent(), e2.getX(), e2.getY());
    }

    @Override
    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> tracks = this.getSelectedTracks();
        String popupTitle = tracks.size() == 1 ? tracks.iterator().next().getName() : "Total Tracks Selected: " + tracks.size();
        return popupTitle;
    }

    public String getTooltipTextForLocation(int x, int y) {
        List<MouseableRegion> mouseableRegions = this.getTrackRegions();
        for (MouseableRegion mouseableRegion : mouseableRegions) {
            if (!mouseableRegion.containsPoint(x, y)) continue;
            return mouseableRegion.getText();
        }
        return "";
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.repaint();
    }

    private synchronized void createDnDImage() {
        this.dndImage = new BufferedImage(this.getWidth(), 2, 2);
        Graphics g2 = this.dndImage.getGraphics();
        g2.setColor(Color.blue);
        g2.drawLine(1, 0, this.getWidth() - 2, 0);
        g2.drawLine(1, 1, this.getWidth() - 2, 1);
    }

    protected void shiftSelectTracks(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.trackRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            Set<Track> clickedTracks = mouseRegion.getTracks();
            if (clickedTracks != null && clickedTracks.size() > 0) {
                Track t = (Track)clickedTracks.iterator().next();
                IGVMainFrame.getInstance().getTrackManager().shiftSelectTracks(t);
            }
            return;
        }
    }

    private TrackGroup getGroup(int y) {
        for (GroupExtent ge : this.groupExtents) {
            if (!ge.contains(y)) continue;
            return ge.group;
        }
        return null;
    }

    private void selectGroup(TrackGroup group) {
        this.selectedGroup = group;
        for (Track t : this.selectedGroup.getTracks()) {
            t.setSelected(true);
        }
    }

    int getGroupGapNumber(int y) {
        for (int i2 = 0; i2 < this.groupExtents.size(); ++i2) {
            if (!this.groupExtents.get(i2).isAfter(y)) continue;
            return i2;
        }
        return this.groupExtents.size();
    }

    class GroupExtent {
        TrackGroup group;
        int minY;
        int maxY;

        GroupExtent(TrackGroup group, int minY, int maxY) {
            this.group = group;
            this.maxY = maxY;
            this.minY = minY;
        }

        boolean contains(int y) {
            return y > this.minY && y <= this.maxY;
        }

        boolean isAfter(int y) {
            return this.minY > y;
        }
    }

    class DropListener
    extends AbstractGhostDropManager {
        TrackNamePanel panel;

        public DropListener(TrackNamePanel target) {
            super(target);
            this.panel = target;
        }

        @Override
        public void ghostDropped(GhostDropEvent e2) {
            boolean isInTarget;
            Point startPoint = e2.getStartLocation();
            Point dropPoint = this.getTranslatedPoint(e2.getDropLocation());
            Rectangle bounds = this.component.getVisibleRect();
            boolean bl = isInTarget = dropPoint.y > bounds.y && (double)dropPoint.y < bounds.getMaxY();
            if (isInTarget) {
                this.tracksDropped(startPoint, dropPoint, e2.getTracks());
                e2.removeTracksFromSource();
                e2.setTracksDropped(true);
            } else {
                TrackPanel view = (TrackPanel)TrackNamePanel.this.getParent();
                if (e2.isTracksDropped()) {
                    view.removeTracks(e2.getTracks());
                } else {
                    e2.addSourcePanel(view);
                }
            }
        }

        void tracksDropped(Point startPoint, Point dropPoint, List<Track> tracks) {
            Iterator<Track> tmp;
            TrackPanel view = (TrackPanel)TrackNamePanel.this.getParent();
            List<MouseableRegion> regions = TrackNamePanel.this.getTrackRegions();
            boolean before = true;
            MouseableRegion dropRegion = null;
            MouseableRegion startRegion = null;
            for (MouseableRegion region : regions) {
                if (region.containsPoint(dropPoint.x, dropPoint.y)) {
                    dropRegion = region;
                    Rectangle bnds = dropRegion.getBounds();
                    int dy1 = dropPoint.y - bnds.y;
                    int dy2 = bnds.height - dy1;
                    boolean bl = before = dy1 < dy2;
                }
                if (region.containsPoint(startPoint.x, startPoint.y)) {
                    startRegion = region;
                }
                if (dropRegion == null || startRegion == null) continue;
                break;
            }
            Track dropTrack = null;
            if (dropRegion != null && (tmp = dropRegion.getTracks().iterator()).hasNext()) {
                dropTrack = tmp.next();
            }
            view.moveSelectedTracksTo(tracks, dropTrack, before);
            IGVMainFrame.getInstance().doResizeTrackPanels();
        }
    }

    class NamePanelMouseAdapter
    extends MouseInputAdapter {
        boolean isDragging = false;
        List<Track> dragTracks = new ArrayList<Track>();
        Point dragStart = null;

        NamePanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (log.isDebugEnabled()) {
                log.debug("Enter mousePressed");
            }
            this.dragStart = e2.getPoint();
            TrackNamePanel.this.requestFocus();
            TrackNamePanel.this.grabFocus();
            boolean isGrouped = TrackNamePanel.this.isGrouped();
            if (e2.isPopupTrigger()) {
                if (!isGrouped && !TrackNamePanel.this.isTrackSelected(e2)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e2);
                }
                TrackNamePanel.this.openPopupMenu(e2);
            } else if (e2.getButton() == 1) {
                if (isGrouped) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackGroup g2 = TrackNamePanel.this.getGroup(e2.getY());
                    if (g2 == TrackNamePanel.this.selectedGroup) {
                        TrackNamePanel.this.selectedGroup = null;
                    } else {
                        TrackNamePanel.this.selectGroup(TrackNamePanel.this.getGroup(e2.getY()));
                    }
                } else if (e2.isMetaDown() || e2.isControlDown()) {
                    TrackNamePanel.this.toggleTrackSelections(e2);
                } else if (e2.isShiftDown()) {
                    TrackNamePanel.this.shiftSelectTracks(e2);
                } else if (!TrackNamePanel.this.isTrackSelected(e2)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e2);
                }
            } else if (!isGrouped && !TrackNamePanel.this.isTrackSelected(e2)) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e2);
            }
            IGVMainFrame.getInstance().repaintNamePanels();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (log.isDebugEnabled()) {
                log.debug("Enter mouseReleased");
            }
            if (this.isDragging) {
                Component c2 = e2.getComponent();
                IGVMainFrame.getInstance().endDnD();
                GhostGlassPane glassPane = IGVMainFrame.getInstance().getDnDGlassPane();
                Point p2 = (Point)e2.getPoint().clone();
                SwingUtilities.convertPointToScreen(p2, c2);
                Point eventPoint = (Point)p2.clone();
                SwingUtilities.convertPointFromScreen(p2, glassPane);
                glassPane.setPoint(p2);
                glassPane.setVisible(false);
                glassPane.setImage(null);
                this.fireGhostDropEvent(new GhostDropEvent(this.dragStart, eventPoint, this.dragTracks));
                if (TrackNamePanel.this.selectedGroup != null) {
                    int idx = TrackNamePanel.this.getGroupGapNumber(e2.getY());
                    TrackPanel dataTrackView = (TrackPanel)TrackNamePanel.this.getParent();
                    dataTrackView.moveGroup(TrackNamePanel.this.selectedGroup, idx);
                    dataTrackView.repaint();
                }
                TrackNamePanel.this.selectedGroup = null;
            }
            if (e2.isPopupTrigger()) {
                TrackNamePanel.this.openPopupMenu(e2);
            } else if (!(this.isDragging || e2.isMetaDown() || e2.isControlDown() || e2.isShiftDown())) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e2);
                IGVMainFrame.getInstance().repaintNamePanels();
            }
            this.isDragging = false;
            this.dragTracks.clear();
            TrackNamePanel.this.dndImage = null;
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            Component c2 = e2.getComponent();
            if (e2.isPopupTrigger()) {
                return;
            }
            if (!this.isDragging) {
                if (e2.getPoint().distance(this.dragStart) < 5.0) {
                    return;
                }
                this.dragStart.x = TrackNamePanel.this.getWidth() / 2;
                IGVMainFrame.getInstance().startDnD();
                if (TrackNamePanel.this.dndImage == null) {
                    TrackNamePanel.this.createDnDImage();
                }
                IGVMainFrame.getInstance().getDnDGlassPane().setImage(TrackNamePanel.this.dndImage);
                this.isDragging = true;
                this.dragTracks.clear();
                this.dragTracks.addAll(IGVMainFrame.getInstance().getTrackManager().getSelectedTracks());
                TrackNamePanel.this.selectedGroup = TrackNamePanel.this.getGroups().size() > 0 ? TrackNamePanel.this.getGroup(e2.getY()) : null;
            }
            if (this.isDragging) {
                final GhostGlassPane glassPane = IGVMainFrame.getInstance().getDnDGlassPane();
                Point p2 = (Point)e2.getPoint().clone();
                p2.x = TrackNamePanel.this.getWidth() / 2;
                SwingUtilities.convertPointToScreen(p2, c2);
                SwingUtilities.convertPointFromScreen(p2, glassPane);
                glassPane.setPoint(p2);
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle bounds = new Rectangle(TrackNamePanel.this.getBounds());
                        bounds.height = 10000;
                        glassPane.paintImmediately(bounds);
                    }
                });
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            int x = e2.getX();
            int y = e2.getY();
            TrackNamePanel.this.setToolTipText(TrackNamePanel.this.getTooltipTextForLocation(x, y));
        }

        protected void fireGhostDropEvent(GhostDropEvent evt) {
            Iterator<DropListener> it = dropListeners.iterator();
            while (it.hasNext()) {
                ((GhostDropListener)it.next()).ghostDropped(evt);
            }
        }
    }
}

