/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVTool;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.RegionOfInterestTool;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.DataPanelPainter;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.PanAndZoomTool;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.Packable;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.jdesktop.layout.GroupLayout;

public class DataPanel
extends TrackPanelComponent {
    private static Logger log = Logger.getLogger(DataPanel.class);
    private static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
    private PanAndZoomTool panAndZoomTool;
    private IGVTool currentTool;
    private IGVTool previousTool;
    private IGVTool defaultTool;
    private Point tooltipTextPosition;
    static DecimalFormat locationFormatter = new DecimalFormat();
    private boolean isWaitingForToolTipText = false;

    public DataPanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.init();
        this.setFocusable(true);
        this.setAutoscrolls(true);
        this.setToolTipText("Data panel");
        DropTarget target = new DropTarget(this, new FileDropTargetListener(trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
    }

    public PanAndZoomTool getPanAndZoomTool() {
        return this.panAndZoomTool;
    }

    public JScrollBar getVerticalScrollbar() {
        Container sp;
        for (sp = this.getParent(); sp != null && !(sp instanceof JScrollPane); sp = sp.getParent()) {
        }
        return sp == null ? null : ((JScrollPane)sp).getVerticalScrollBar();
    }

    public void setCurrentTool(final IGVTool tool) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (DataPanel.this.defaultTool == null) {
                    DataPanel.this.defaultTool = tool;
                }
                if (DataPanel.this.currentTool != null) {
                    DataPanel.this.removeKeyListener(DataPanel.this.currentTool);
                    DataPanel.this.removeMouseListener(DataPanel.this.currentTool);
                    DataPanel.this.removeMouseMotionListener(DataPanel.this.currentTool);
                }
                DataPanel.this.currentTool = tool == null ? DataPanel.this.defaultTool : tool;
                if (DataPanel.this.currentTool != null) {
                    DataPanel.this.currentTool.showCursor();
                    DataPanel.this.addKeyListener(DataPanel.this.currentTool);
                    DataPanel.this.addMouseListener(DataPanel.this.currentTool);
                    DataPanel.this.addMouseMotionListener(DataPanel.this.currentTool);
                }
            }
        });
    }

    public IGVTool getCurrentTool() {
        return this.currentTool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        RenderContext context = null;
        try {
            int startLoc;
            Graphics2D graphics2D = (Graphics2D)g2.create();
            double scale = this.getViewContext().getScale();
            String chromosomeName = this.getViewContext().getChrName();
            double startLocation = this.getViewContext().getOrigin();
            double endLocation = startLocation + (double)this.getWidth() * scale + 1.0;
            int zoom = this.getViewContext().getZoom();
            String genomeId = this.getViewContext().getGenomeId();
            context = new RenderContext(genomeId, chromosomeName, startLocation, endLocation, zoom, scale, this.getVisibleRect(), graphics2D);
            if (IS_MAC) {
                this.applyMacPerformanceHints((Graphics2D)g2);
            }
            graphics2D.setBackground(this.getBackground());
            ArrayList<TrackGroup> groups = new ArrayList<TrackGroup>(this.getTrackGroups());
            boolean hasTracks = false;
            for (TrackGroup group : groups) {
                if (group.getTracks().size() <= 0) continue;
                hasTracks = true;
                break;
            }
            if (!hasTracks) {
                this.removeMousableRegions();
                return;
            }
            int trackWidth = this.getWidth();
            int trackHeight = this.getHeight();
            DataPanelPainter painter = new DataPanelPainter();
            painter.paint(groups, context, trackWidth, trackHeight, this.getBackground(), this.getVisibleRect());
            this.computeMousableRegions(groups);
            int trackX = 0;
            int trackY = 0;
            for (TrackGroup group : groups) {
                if (groups.size() > 1) {
                    trackY += 10;
                }
                for (Track track : group.getTracks()) {
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, this.getWidth(), track.getHeight());
                    track.renderAxis(context, rect);
                    trackY += track.getHeight();
                }
            }
            if (this.currentTool instanceof RegionOfInterestTool && (startLoc = ((RegionOfInterestTool)this.currentTool).getRoiStart()) > 0) {
                int start = this.getViewContext().getPixelPosition(startLoc);
                g2.setColor(Color.BLACK);
                graphics2D.drawLine(start, 0, start, this.getHeight());
            }
            if (IGVMainFrame.getInstance().isShowRegionsOfInterestBarsOn()) {
                this.drawAllRegions(g2);
            }
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAllRegions(Graphics g2) {
        Collection<RegionOfInterest> regions = IGVMainFrame.getInstance().getSession().getRegionsOfInterest(this.getViewContext().getChrName());
        if (regions == null || regions.isEmpty()) {
            return;
        }
        boolean drawBars = PreferenceManager.getInstance().isShowRegionBars();
        Graphics2D graphics2D = (Graphics2D)g2.create();
        try {
            for (RegionOfInterest regionOfInterest : regions) {
                if (!drawBars && regionOfInterest != IGVMainFrame.getInstance().getSelectedRegion()) continue;
                this.drawRegion(graphics2D, regionOfInterest);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    private boolean drawRegion(Graphics2D graphics2D, RegionOfInterest regionOfInterest) {
        Integer regionStart = regionOfInterest.getStart();
        if (regionStart == null) {
            return true;
        }
        Integer regionEnd = regionOfInterest.getEnd();
        if (regionEnd == null) {
            regionEnd = regionStart;
        }
        ViewContext viewContext = this.getViewContext();
        int start = viewContext.getPixelPosition(regionStart.intValue());
        int end = viewContext.getPixelPosition(regionEnd.intValue());
        int height = this.getHeight();
        graphics2D.setColor(regionOfInterest.getForegroundColor());
        graphics2D.drawLine(start, 0, start, height);
        graphics2D.drawLine(end, 0, end, height);
        return false;
    }

    protected String generateTileKey(String chr, int t, int zoomLevel) {
        String key = chr + "_z_" + zoomLevel + "_t_" + t;
        return key;
    }

    private void computeMousableRegions(Collection<TrackGroup> groups) {
        this.removeMousableRegions();
        int trackX = 0;
        int trackY = 0;
        for (TrackGroup group : groups) {
            if (groups.size() > 1) {
                trackY += 10;
            }
            for (Track track : group.getTracks()) {
                if (!track.isVisible()) continue;
                int trackWidth = this.getWidth();
                int trackHeight = track.getHeight();
                Rectangle actualAreaOnDataPanel = new Rectangle(trackX, trackY, trackWidth, trackHeight);
                this.addMousableRegion(new MouseableRegion(actualAreaOnDataPanel, track));
                trackY += track.getHeight();
            }
        }
    }

    public void doResize() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                TrackPanel trackView = (TrackPanel)DataPanel.this.getParent();
                if (trackView == null) {
                    return;
                }
                int newHeight = DataPanel.this.calculateResizeHeight();
                trackView.setHeight(newHeight);
            }
        });
    }

    public void debugDump(String trackName) {
        TrackPanel trackView = (TrackPanel)this.getParent();
        if (trackView == null) {
            return;
        }
        if (trackView.hasTracks()) {
            String name = this.getTrackSetID().toString();
            System.out.println("\n\n" + name + " Track COUNT:" + trackView.getTracks().size());
            System.out.println("\t\t\t\t" + name + " scrollpane height     = " + trackView.getScrollPane().getHeight());
            System.out.println("\t\t\t\t" + name + " viewport height       = " + trackView.getViewportHeight());
            System.out.println("\t\t\t\t" + name + " TrackView min height  = " + trackView.getMinimumSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView pref height = " + trackView.getPreferredSize().getHeight());
            System.out.println("\t\t\t\t" + name + " TrackView height      = " + trackView.getSize().getHeight());
        }
    }

    public Track getTrack(int x, int y) {
        for (MouseableRegion mouseRegion : this.getTrackRegions()) {
            if (!mouseRegion.containsPoint(x, y)) continue;
            return mouseRegion.getTracks().iterator().next();
        }
        return null;
    }

    public void updateTooltipText(int x, int y) {
        StringBuffer popupTextBuffer = new StringBuffer();
        double location = this.getViewContext().getChromosomePosition(x);
        double displayLocation = location + 1.0;
        popupTextBuffer.append("<html>");
        Track track = null;
        List<MouseableRegion> regions = this.getTrackRegions();
        for (MouseableRegion mouseRegion : regions) {
            if (!mouseRegion.containsPoint(x, y)) continue;
            track = mouseRegion.getTracks().iterator().next();
            if (track == null) break;
            int yRelative = y - mouseRegion.getBounds().y;
            List<Track> overlays = IGVMainFrame.getInstance().getTrackManager().getOverlayTracks(track);
            if (overlays != null) {
                for (Track overlay : overlays) {
                    if (overlay == track || overlay.getValueStringAt(this.getViewContext().getChrName(), displayLocation, yRelative) == null) continue;
                    popupTextBuffer.append(this.getPopUpText(overlay, displayLocation, yRelative));
                    popupTextBuffer.append("<br>");
                }
            }
            popupTextBuffer.append(this.getPopUpText(track, displayLocation, y));
            break;
        }
        popupTextBuffer.append("<br>Location: ");
        popupTextBuffer.append(locationFormatter.format((int)displayLocation));
        this.setToolTipText(popupTextBuffer.toString());
    }

    @Override
    public final String getToolTipText() {
        if (!this.isWaitingForToolTipText) {
            this.isWaitingForToolTipText = true;
            if (this.tooltipTextPosition != null) {
                this.updateTooltipText(this.tooltipTextPosition.x, this.tooltipTextPosition.y);
            }
            this.isWaitingForToolTipText = false;
        }
        return super.getToolTipText();
    }

    @Override
    public String getPopupMenuTitle(int x, int y) {
        String popupTitle;
        block0: {
            Iterator<Track> i$;
            Collection<Track> tracks = this.getSelectedTracks();
            popupTitle = "";
            if (tracks.isEmpty() || !(i$ = tracks.iterator()).hasNext()) break block0;
            Track track = i$.next();
            popupTitle = track.getName();
        }
        return popupTitle;
    }

    String getPopUpText(Track track, double location, int y) {
        DataRange axisDefinition = track.getDataRange();
        StringBuffer buf = new StringBuffer();
        String value = track.getValueStringAt(this.getViewContext().getChrName(), location, y);
        if (value != null) {
            buf.append(value);
        }
        return buf.toString();
    }

    private void init() {
        this.panAndZoomTool = new PanAndZoomTool(this);
        this.setCurrentTool(this.getPanAndZoomTool());
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setMinimumSize(new Dimension(700, 0));
        this.setRequestFocusEnabled(false);
        GroupLayout featureTrackPanelLayout = new GroupLayout(this);
        this.setLayout(featureTrackPanelLayout);
        featureTrackPanelLayout.setHorizontalGroup(featureTrackPanelLayout.createParallelGroup(1).add(0, 708, Short.MAX_VALUE));
        featureTrackPanelLayout.setVerticalGroup(featureTrackPanelLayout.createParallelGroup(1).add(0, 228, Short.MAX_VALUE));
        KeyAdapter keyAdapter = new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyChar() == '+' || e2.getKeyCode() == 521) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.getViewContext().incrementZoom(1);
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyChar() == '-' || e2.getKeyCode() == 521) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.getViewContext().incrementZoom(-1);
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 39) {
                    DataPanel.this.getViewContext().shiftOriginPixels(5.0);
                } else if (e2.getKeyCode() == 37) {
                    DataPanel.this.getViewContext().shiftOriginPixels(-5.0);
                } else if (e2.getKeyCode() == 36) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.getViewContext().shiftOriginPixels(-DataPanel.this.getWidth());
                        DataPanel.this.getViewContext().recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 35) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        DataPanel.this.getViewContext().shiftOriginPixels(DataPanel.this.getWidth());
                        DataPanel.this.getViewContext().recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                } else if (e2.getKeyCode() == 521 || e2.getKeyCode() == 45) {
                    // empty if block
                }
            }
        };
        this.addKeyListener(keyAdapter);
        DataPanelMouseAdapter mouseAdapter = new DataPanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int adjustedX = this.getAdjustedX();
        int adjustedWidth = this.getAdjustedWidth();
        super.setBounds(adjustedX, y, adjustedWidth, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        int adjustedX = this.getAdjustedX();
        int adjustedWidth = this.getAdjustedWidth();
        super.setBounds(new Rectangle(adjustedX, r.y, adjustedWidth, r.height));
    }

    @Override
    public void setSize(int width, int height) {
        int adjustedWidth = this.getAdjustedWidth();
        super.setSize(adjustedWidth, height);
    }

    @Override
    public void setSize(Dimension d2) {
        int adjustedWidth = this.getAdjustedWidth();
        super.setSize(new Dimension(adjustedWidth, d2.height));
    }

    private int getAdjustedX() {
        Component[] children;
        int adjustedX = 0;
        Integer attributePanelEnd = null;
        int width = 0;
        for (Component child : children = this.getParent().getComponents()) {
            int x;
            if (!(child instanceof Packable)) continue;
            if (attributePanelEnd != null) break;
            adjustedX = x = child.getX();
            width = child.getWidth();
            attributePanelEnd = new Integer(x + width);
            break;
        }
        if (attributePanelEnd != null) {
            adjustedX = attributePanelEnd;
            if (width > 0) {
                adjustedX += IGVPanel.X_SPACING_BETWEEN_COMPONENTS;
            }
        }
        return adjustedX;
    }

    private int getAdjustedWidth() {
        int minimumWidth;
        int width = this.getWidth();
        Container parent = this.getParent();
        if (parent != null) {
            int parentVisibleWidth = ((JPanel)parent).getVisibleRect().width;
            int viewportWidth = ((TrackPanel)parent).getViewportWidth();
            if (parentVisibleWidth < viewportWidth) {
                viewportWidth = parentVisibleWidth;
            }
            int delta = viewportWidth - (this.getX() + width);
            width = this.getWidth() + delta;
        }
        if (width < (minimumWidth = this.getMinimumSize().width)) {
            width = minimumWidth;
        }
        return width;
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    private void applyMacPerformanceHints(Graphics2D g2D) {
        g2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(TrackPanel dataPanel2) {
            this.panel = dataPanel2;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            MessageCollection messages = new MessageCollection();
            try {
                String obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                if (obj.startsWith("http:")) {
                    IGVMainFrame.getInstance().loadTracks(Arrays.asList(new ResourceLocator(obj)));
                } else {
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : files) {
                        try {
                            IGVMainFrame.getInstance().getTrackManager().load(file, this.panel);
                        }
                        catch (DataLoadException de) {
                            messages.append(de.getMessage());
                        }
                    }
                }
                if (messages != null && !messages.isEmpty()) {
                    MessageUtils.showAndLogErrorMessage(IGVMainFrame.getInstance(), messages.getFormattedMessage(), log);
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), e2);
            }
            IGVMainFrame.getInstance().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }

    class DataPanelMouseAdapter
    extends MouseInputAdapter {
        DataPanelMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            IGVMainFrame.getInstance().setSelectedRegion(null);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SwingUtilities.getWindowAncestor(DataPanel.this).isActive()) {
                DataPanel.this.requestFocus();
            }
            if (e2.isPopupTrigger()) {
                IGVMainFrame.getInstance().getTrackManager().clearSelections();
                DataPanel.this.selectTracks(e2);
                DataPanel.this.openPopupMenu(e2);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            DataPanel.this.tooltipTextPosition = e2.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                IGVMainFrame.getInstance().getTrackManager().clearSelections();
                DataPanel.this.selectTracks(e2);
                DataPanel.this.openPopupMenu(e2);
            }
        }
    }
}

