/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.broad.igv.feature.Feature;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GeneTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.util.MessageUtils;

public class GlobalKeyDispatcher
implements KeyEventDispatcher {
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();
    private IGVMainFrame mainFrame;

    public GlobalKeyDispatcher() {
        this.init();
        this.mainFrame = IGVMainFrame.getInstance();
    }

    public InputMap getInputMap() {
        return this.keyStrokes;
    }

    public ActionMap getActionMap() {
        return this.actions;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Action action;
        if (event.getKeyCode() == 27) {
            IGVMainFrame.getInstance().getTrackManager().clearSelections();
            IGVMainFrame.getInstance().repaint();
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        String actionKey = (String)this.keyStrokes.get(ks);
        if (event.getKeyCode() == 17) {
            boolean flag = !event.isControlDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }
        if (actionKey != null && (action = this.actions.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, event.getModifiers()));
            return true;
        }
        return false;
    }

    public void init() {
        KeyStroke nextKey = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke prevKey = KeyStroke.getKeyStroke(66, 2, false);
        KeyStroke toolsKey = KeyStroke.getKeyStroke(84, 8, false);
        KeyStroke regionKey = KeyStroke.getKeyStroke(82, 2, false);
        KeyStroke backKey1 = KeyStroke.getKeyStroke(93, 256, false);
        KeyStroke backKey2 = KeyStroke.getKeyStroke(37, 512, false);
        KeyStroke forwardKey1 = KeyStroke.getKeyStroke(91, 256, false);
        KeyStroke forwardKey2 = KeyStroke.getKeyStroke(39, 512, false);
        AbstractAction toolAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                IGVMainFrame.getInstance().enableExtrasMenu();
                this.setEnabled(true);
            }
        };
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextFeature(true);
                this.setEnabled(true);
            }
        };
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                GlobalKeyDispatcher.this.nextFeature(false);
                this.setEnabled(true);
            }
        };
        AbstractAction regionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                this.setEnabled(false);
                ViewContext.Range currentRange = ViewContext.getInstance().getCurrentRange();
                RegionOfInterest regionOfInterest = new RegionOfInterest(currentRange.getChr(), currentRange.getStart(), currentRange.getEnd(), null);
                IGVMainFrame.getInstance().addRegionOfInterest(regionOfInterest);
                this.setEnabled(true);
            }
        };
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String locus = ViewContext.getInstance().history.back();
                if (locus != null) {
                    new SearchCommand(ViewContext.getInstance(), locus, false).execute();
                    IGVMainFrame.getInstance().refreshCommandBar();
                }
            }
        };
        AbstractAction forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String locus = ViewContext.getInstance().history.forward();
                if (locus != null) {
                    new SearchCommand(ViewContext.getInstance(), locus, false).execute();
                    IGVMainFrame.getInstance().refreshCommandBar();
                }
            }
        };
        this.getInputMap().put(nextKey, "nextFeature");
        this.getActionMap().put("nextFeature", nextAction);
        this.getInputMap().put(prevKey, "prevFeature");
        this.getActionMap().put("prevFeature", prevAction);
        this.getInputMap().put(toolsKey, "tools");
        this.getActionMap().put("tools", toolAction);
        this.getInputMap().put(regionKey, "region");
        this.getActionMap().put("region", regionAction);
        this.getInputMap().put(backKey1, "back");
        this.getInputMap().put(backKey2, "back");
        this.getActionMap().put("back", backAction);
        this.getInputMap().put(forwardKey1, "forward");
        this.getInputMap().put(forwardKey2, "forward");
        this.getActionMap().put("forward", forwardAction);
    }

    private void nextFeature(boolean forward) {
        ViewContext vc = this.getViewContext();
        Collection<Track> tracks = IGVMainFrame.getInstance().getTrackManager().getSelectedTracks();
        if (tracks.size() == 1) {
            try {
                Track t = tracks.iterator().next();
                if (!(t instanceof FeatureTrack) && !(t instanceof GeneTrack)) {
                    return;
                }
                Feature f2 = null;
                if (t instanceof FeatureTrack) {
                    f2 = ((FeatureTrack)t).nextFeature(vc.getChrName(), vc.getCenter(), forward);
                } else if (t instanceof GeneTrack) {
                    f2 = ((GeneTrack)t).nextFeature(vc.getChrName(), vc.getCenter(), forward);
                }
                if (f2 != null) {
                    String chr = vc.getGenome().getChromosomeAlias(f2.getChr());
                    double newCenter = f2.getStart();
                    if (!chr.equals(vc.getChrName())) {
                        int zoom = vc.getZoom();
                        vc.setChrName(chr);
                        vc.zoomAndCenter(zoom);
                    }
                    vc.centerOnLocation(newCenter);
                }
            }
            catch (IOException e2) {
                MessageUtils.showMessage("Error encountered reading features: " + e2.getMessage());
            }
        } else {
            MessageUtils.showMessage("To use track panning you must first select a single feature track.");
        }
    }

    private ViewContext getViewContext() {
        return ViewContext.getInstance();
    }
}

