/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.BasicFeatureRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class FeatureTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(FeatureTrack.class);
    static int maxLevels = 200;
    private boolean expanded;
    private List<Rectangle> featureRects = new ArrayList<Rectangle>();
    private PackedFeatures packedFeatures;
    private FeatureRenderer renderer;
    private DataRenderer coverageRenderer;
    private boolean showFeatures = true;
    protected FeatureSource source;
    private static final int MINIMUM_FEATURE_SPACING = 1;
    private int visibilityWindow = -1;
    private Rectangle expandButtonRect = this.expandButtonRect = new Rectangle();
    private static final int EXPAND_ICON_BUFFER_WIDTH = 17;
    private static final int EXPAND_ICON_BUFFER_HEIGHT = 17;
    public static final int MARGIN = 5;
    public static final String FEATURE_VISIBILITY_WINDOW = "featureVisibilityWindow";
    private boolean featuresLoading = false;
    private int[] p1 = new int[3];
    private int[] p2 = new int[3];
    private TimerTask currentBrowserTask = null;

    public FeatureTrack(String id, FeatureSource source) {
        super(id);
        this.init(source);
    }

    public FeatureTrack(ResourceLocator locator, FeatureSource source) {
        super(locator);
        this.init(source);
        this.getMinimumHeight();
    }

    private void init(FeatureSource source) {
        this.expanded = PreferenceManager.getInstance().isExpandTracks();
        this.source = source;
        this.setMinimumHeight(10);
        this.setColor(Color.blue.darker());
        this.coverageRenderer = new HeatmapRenderer();
        if (source.getBinSize() > 0) {
            this.visibilityWindow = source.getBinSize();
        }
    }

    @Override
    public void setTrackProperties(TrackProperties trackProperties) {
        super.setTrackProperties(trackProperties);
        if (trackProperties.getFeatureVisibilityWindow() >= 0) {
            this.setVisibilityWindow(trackProperties.getFeatureVisibilityWindow());
        }
    }

    @Override
    public int getHeight() {
        if (!this.isVisible()) {
            return 0;
        }
        return super.getHeight() * Math.max(1, this.getNumberOfFeatureLevels());
    }

    public int getNumberOfFeatureLevels() {
        return this.expanded ? (this.packedFeatures == null ? 1 : this.packedFeatures.getRowCount()) : 1;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        return -3.4028235E38f;
    }

    @Override
    public FeatureRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(BasicFeatureRenderer.class);
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y) {
        if (this.showFeatures) {
            double scale = ViewContext.getInstance().getScale();
            double origin = ViewContext.getInstance().getOrigin();
            int x = (int)((position - origin) / scale);
            if (x < 17) {
                if (this.expandButtonRect.contains(x, y)) {
                    return "<b><strong>Click to " + (this.isExpanded() ? " collapse track " : " expand track</strong></b>");
                }
                return "";
            }
            Feature feature = this.getFeatureAt(chr, position, y);
            return feature == null ? null : feature.getValueString(position, null);
        }
        int zoom = Math.max(0, ViewContext.getInstance().getZoom());
        List<LocusScore> scores = this.source.getCoverageScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return "";
        }
        double bpPerPixel = ViewContext.getInstance().getScale();
        double minWidth = 1.0 * bpPerPixel;
        LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
        return score == null ? "" : "Mean count: " + score.getScore();
    }

    private Feature getFeatureAt(String chr, double position, int y) {
        if (this.packedFeatures == null) {
            return null;
        }
        Feature feature = null;
        int levelNumber = 0;
        if (this.featureRects != null) {
            for (int i2 = 0; i2 < this.featureRects.size(); ++i2) {
                Rectangle r = this.featureRects.get(i2);
                if (y < r.y || !((double)y <= r.getMaxY())) continue;
                levelNumber = i2;
                break;
            }
        }
        int nLevels = this.getNumberOfFeatureLevels();
        List<Feature> features = null;
        features = nLevels > 1 && levelNumber < nLevels ? ((FeatureRow)((PackedFeatures)this.packedFeatures).rows.get((int)levelNumber)).features : this.packedFeatures.features;
        if (features != null) {
            double bpPerPixel = ViewContext.getInstance().getScale();
            double minWidth = 1.0 * bpPerPixel;
            feature = (Feature)FeatureUtils.getFeatureAt(position, minWidth, features);
        }
        return feature;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.count;
    }

    @Override
    public boolean handleClick(MouseEvent e2) {
        if (e2.getClickCount() == 1 && !e2.isShiftDown() && !e2.isPopupTrigger() && e2.getButton() == 1) {
            if (e2.getX() < 17) {
                if (this.expandButtonRect.contains(e2.getPoint())) {
                    this.setExpanded(!this.expanded);
                    IGVMainFrame.getInstance().doResizeTrackPanels();
                    IGVMainFrame.getInstance().doRefresh();
                }
                return true;
            }
            Feature f2 = this.getFeatureAtMousePosition(e2);
            if (f2 != null) {
                String trackURL;
                String url = f2.getURL();
                if (url == null && (trackURL = this.getUrl()) != null && f2.getIdentifier() != null) {
                    String encodedID = URLEncoder.encode(f2.getIdentifier());
                    url = trackURL.replaceAll("\\$\\$", encodedID);
                }
                if (url != null) {
                    this.scheduleBrowserTask(url, UIConstants.getDoubleClickInterval());
                    e2.consume();
                    return true;
                }
            }
        } else {
            this.cancelBrowserTask();
        }
        return false;
    }

    @Override
    public Feature getFeatureAtMousePosition(MouseEvent e2) {
        double location = this.getViewContext().getChromosomePosition(e2.getX());
        double displayLocation = location + 1.0;
        Feature f2 = this.getFeatureAt(this.getViewContext().getChrName(), displayLocation, e2.getY());
        return f2;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        this.getRenderer().setOverlayMode(true);
        this.renderFeatures(context, rect);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.getRenderer().setOverlayMode(false);
        Rectangle renderRect = new Rectangle(rect);
        renderRect.y += 5;
        renderRect.height -= 5;
        double windowSize = (double)rect.width * context.getScale();
        int vw = this.getVisibilityWindow();
        this.showFeatures = true;
        if (vw == 0) {
            this.showFeatures = !context.getChr().equals("All");
        } else if (vw > 0) {
            boolean bl = this.showFeatures = !context.getChr().equals("All") && windowSize <= (double)vw;
        }
        if (this.showFeatures) {
            this.renderFeatures(context, renderRect);
        } else {
            this.renderCoverage(context, renderRect);
        }
        boolean showIcon = PreferenceManager.getInstance().getBooleanPreference("SHOW_EXPAND_ICON", true);
        if (showIcon && !IGVMainFrame.getInstance().isExportingSnapshot()) {
            this.renderExpandTool(context, rect);
        }
    }

    private void renderCoverage(RenderContext context, Rectangle inputRect) {
        List<LocusScore> scores = this.source.getCoverageScores(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom());
        if (scores == null) {
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(inputRect);
            textRect.height = Math.min(inputRect.height, 20);
            String message = context.getChr().equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, textRect, g2);
        } else {
            float max = this.getMaxEstimate(scores);
            ContinuousColorScale cs = this.getColorScale();
            if (cs != null) {
                cs.setPosEnd(max);
            }
            this.setDataRange(new DataRange(0.0f, 0.0f, max));
            this.coverageRenderer.render(this, scores, context, inputRect);
        }
    }

    private float getMaxEstimate(List<LocusScore> scores) {
        float max = 0.0f;
        int n2 = Math.min(200, scores.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            max = Math.max(max, scores.get(i2).getScore());
        }
        return max;
    }

    private void renderExpandTool(RenderContext contect, Rectangle rect) {
        if (this.packedFeatures == null || this.packedFeatures.getRowCount() <= 1) {
            return;
        }
        Graphics2D g2d = contect.getGraphic2DForColor(Color.DARK_GRAY);
        int levelHeight = this.getHeight() / this.getNumberOfFeatureLevels() + 1;
        g2d.clearRect(rect.x, rect.y, 17, levelHeight);
        this.expandButtonRect.x = rect.x + 3;
        this.expandButtonRect.y = rect.y + 5 + 4;
        this.expandButtonRect.width = 10;
        this.expandButtonRect.height = 10;
        if (this.expanded) {
            this.p1[0] = this.expandButtonRect.x;
            this.p1[1] = this.expandButtonRect.x + 8;
            this.p1[2] = this.expandButtonRect.x + 4;
            this.p2[0] = this.expandButtonRect.y;
            this.p2[1] = this.expandButtonRect.y;
            this.p2[2] = this.expandButtonRect.y + 8;
            g2d.fillPolygon(this.p1, this.p2, 3);
        } else {
            this.p1[0] = this.expandButtonRect.x;
            this.p1[1] = this.expandButtonRect.x + 8;
            this.p1[2] = this.expandButtonRect.x;
            this.p2[0] = this.expandButtonRect.y;
            this.p2[1] = this.expandButtonRect.y + 4;
            this.p2[2] = this.expandButtonRect.y + 8;
            g2d.fillPolygon(this.p1, this.p2, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFeatures(RenderContext context, Rectangle inputRect) {
        if (this.featuresLoading) {
            return;
        }
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        if (this.packedFeatures == null || !this.packedFeatures.containsInterval(chr, start, end)) {
            Chromosome c2;
            this.featuresLoading = true;
            int maxEnd = end;
            Genome genome = ViewContext.getInstance().getGenome();
            if (genome != null && (c2 = genome.getChromosome(chr)) != null) {
                maxEnd = Math.max(c2.getLength(), end);
            }
            int delta = (end - start) / 2;
            int expandedStart = Math.max(0, start - delta);
            int expandedEnd = Math.min(maxEnd, end + delta);
            this.loadFeatures(chr, expandedStart, expandedEnd);
            if (!IGVMainFrame.getInstance().isExportingSnapshot()) {
                return;
            }
        }
        if (this.expanded) {
            List rows = this.packedFeatures.rows;
            if (rows != null && rows.size() > 0) {
                int nLevels = rows.size();
                List<Rectangle> list = this.featureRects;
                synchronized (list) {
                    this.featureRects.clear();
                    double h2 = inputRect.getHeight() / (double)nLevels;
                    Rectangle rect = new Rectangle(inputRect.x, inputRect.y, inputRect.width, (int)h2);
                    for (FeatureRow row : rows) {
                        this.featureRects.add(new Rectangle(rect));
                        this.getRenderer().renderFeatures(row.features, context, rect, this);
                        rect.y = (int)((double)rect.y + h2);
                    }
                }
            }
        } else {
            List features = this.packedFeatures.features;
            if (features != null) {
                this.getRenderer().renderFeatures(features, context, inputRect, this);
            }
        }
    }

    private void loadFeatures(final String chr, final int start, final int end) {
        NamedRunnable runnable = new NamedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Iterator<Feature> iter = FeatureTrack.this.source.getFeatures(chr, start, end);
                    if (iter == null) {
                        FeatureTrack.this.packedFeatures = new PackedFeatures(chr, start, end);
                    } else {
                        FeatureTrack.this.packedFeatures = new PackedFeatures(chr, start, end, iter, this.getName());
                    }
                    IGVMainFrame.getInstance().repaint();
                }
                catch (Throwable e2) {
                    FeatureTrack.this.packedFeatures = new PackedFeatures(chr, start, end);
                    String msg = "Error loading features for interval: " + chr + ":" + start + "-" + end + " <br>" + e2.toString();
                    MessageUtils.showMessage(msg);
                    log.error(msg, e2);
                }
                finally {
                    FeatureTrack.this.featuresLoading = false;
                    if (log.isDebugEnabled()) {
                        log.debug("features loaded");
                    }
                }
            }

            @Override
            public String getName() {
                return "Load features: " + FeatureTrack.this.getName();
            }
        };
        LongRunningTask.submit(runnable);
    }

    @Override
    public void setExpanded(boolean value) {
        this.expanded = value;
    }

    @Override
    public void setHeight(int newHeight) {
        int levelCount = this.getNumberOfFeatureLevels();
        super.setHeight(Math.max(this.getMinimumHeight(), newHeight / levelCount));
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (FeatureRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error("Error instatiating renderer ", ex);
        }
    }

    @Override
    public void setStatType(WindowFunction type) {
    }

    public void setZoom(int zoom) {
    }

    private void cancelBrowserTask() {
        if (this.currentBrowserTask != null) {
            this.currentBrowserTask.cancel();
            this.currentBrowserTask = null;
        }
    }

    private void scheduleBrowserTask(final String url, int delay) {
        this.cancelBrowserTask();
        this.currentBrowserTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException e1) {
                    log.error("Error opening url: " + url);
                }
            }
        };
        new Timer().schedule(this.currentBrowserTask, delay);
    }

    public Feature nextFeature(String chr, double center, boolean forward) throws IOException {
        Feature f2;
        block13: {
            boolean canScroll;
            f2 = null;
            ViewContext vc = ViewContext.getInstance();
            boolean bl = canScroll = forward && !vc.windowAtEnd() || !forward && vc.getOrigin() > 0.0;
            if (this.packedFeatures == null || !this.packedFeatures.containsInterval(chr, (int)center - 1, (int)center + 1)) break block13;
            if (this.packedFeatures.features.size() > 0 && canScroll) {
                f2 = (Feature)(forward ? FeatureUtils.getFeatureAfter(center + 1.0, this.packedFeatures.features) : FeatureUtils.getFeatureBefore(center - 1.0, this.packedFeatures.features));
            }
            if (f2 == null) {
                int binSize = this.source.getBinSize();
                if (forward) {
                    int nextStart = this.packedFeatures.end;
                    String nextChr = chr;
                    while (nextChr != null) {
                        int chrLength = vc.getGenome().getChromosome(nextChr).getLength();
                        while (nextStart < chrLength) {
                            int nextEnd = binSize > 0 ? nextStart + this.source.getBinSize() : chrLength;
                            Iterator<Feature> iter = this.source.getFeatures(nextChr, nextStart, nextEnd);
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Feature feat = iter.next();
                                    if (feat.getStart() <= nextStart) continue;
                                    return feat;
                                }
                            }
                            nextStart = nextEnd;
                        }
                        nextChr = vc.getNextChrName(nextChr);
                        nextStart = 0;
                    }
                } else {
                    int nextEnd = this.packedFeatures.start;
                    String nextChr = chr;
                    while (nextChr != null) {
                        while (nextEnd > 0) {
                            int nextStart = binSize > 0 ? Math.max(0, nextEnd - this.source.getBinSize()) : 0;
                            Iterator<Feature> iter = this.source.getFeatures(nextChr, nextStart, nextEnd);
                            if (iter != null && iter.hasNext()) {
                                Feature prevFeature = null;
                                while (iter.hasNext()) {
                                    Feature feat = iter.next();
                                    if (feat.getStart() >= nextEnd) continue;
                                    prevFeature = feat;
                                }
                                if (prevFeature != null) {
                                    return prevFeature;
                                }
                            }
                            nextEnd = nextStart;
                        }
                        if ((nextChr = vc.getPrevChrName(nextChr)) == null) continue;
                        nextEnd = vc.getGenome().getChromosome(nextChr).getLength();
                    }
                }
            }
        }
        return f2;
    }

    public int getVisibilityWindow() {
        return this.visibilityWindow;
    }

    public void setVisibilityWindow(int windowSize) {
        this.visibilityWindow = windowSize;
        this.source.setBinSize(this.visibilityWindow);
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String fvw = attributes.get(FEATURE_VISIBILITY_WINDOW);
        if (fvw != null) {
            try {
                this.visibilityWindow = Integer.parseInt(fvw);
            }
            catch (NumberFormatException e2) {
                log.error("Error restoring visibilityWindow: " + fvw);
            }
        }
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> stateMap = super.getPersistentState();
        stateMap.put(FEATURE_VISIBILITY_WINDOW, String.valueOf(this.visibilityWindow));
        return stateMap;
    }

    static class PackedFeatures {
        private String trackName;
        private String chr;
        private int start;
        private int end;
        private List<Feature> features;
        private List<FeatureRow> rows;

        PackedFeatures(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.features = Collections.emptyList();
            this.rows = Collections.emptyList();
        }

        PackedFeatures(String chr, int start, int end, Iterator<Feature> iter, String trackName) {
            this.trackName = trackName;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.features = new ArrayList<Feature>(1000);
            this.rows = this.packFeatures(iter);
        }

        int getRowCount() {
            return this.rows.size();
        }

        boolean containsInterval(String chr, int start, int end) {
            return this.chr.equals(chr) && start >= this.start && end <= this.end;
        }

        List<FeatureRow> packFeatures(Iterator<Feature> iter) {
            ArrayList<FeatureRow> rows = new ArrayList<FeatureRow>(10);
            if (iter == null || !iter.hasNext()) {
                return rows;
            }
            Comparator<Feature> lengthComparator = new Comparator<Feature>(){

                @Override
                public int compare(Feature row1, Feature row2) {
                    return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
                }
            };
            Feature firstFeature = iter.next();
            this.features.add(firstFeature);
            int totalCount = 1;
            LinkedHashMap<Integer, PriorityQueue<Feature>> bucketArray = new LinkedHashMap<Integer, PriorityQueue<Feature>>();
            while (iter.hasNext()) {
                Feature feature = iter.next();
                this.features.add(feature);
                int bucketNumber = feature.getStart();
                PriorityQueue<Feature> bucket = (PriorityQueue<Feature>)bucketArray.get(bucketNumber);
                if (bucket == null) {
                    bucket = new PriorityQueue<Feature>(5, lengthComparator);
                    bucketArray.put(bucketNumber, bucket);
                }
                bucket.add(feature);
                ++totalCount;
            }
            FeatureRow currentRow = new FeatureRow();
            currentRow.addFeature(firstFeature);
            int allocatedCount = 1;
            int nextStart = currentRow.end + 1;
            int lastKey = 0;
            int lastAllocatedCount = 0;
            while (allocatedCount < totalCount && rows.size() < maxLevels) {
                if (lastAllocatedCount == allocatedCount) {
                    String msg = "Infinite loop detected while packing features for track: " + this.trackName + ".<br>Not all features will be shown." + "<br>Please contact igv-help@broadinstitute.org";
                    log.error(msg);
                    MessageUtils.showMessage(msg);
                    break;
                }
                lastAllocatedCount = allocatedCount;
                PriorityQueue bucket = null;
                ArrayList<Integer> emptyBucketKeys = new ArrayList<Integer>();
                for (Integer key : bucketArray.keySet()) {
                    lastKey = key;
                    if (key < nextStart) continue;
                    bucket = (PriorityQueue)bucketArray.get(key);
                    Feature feature = (Feature)bucket.poll();
                    if (bucket.isEmpty()) {
                        emptyBucketKeys.add(key);
                    }
                    currentRow.addFeature(feature);
                    nextStart = currentRow.end + 1;
                    ++allocatedCount;
                }
                for (Integer key : emptyBucketKeys) {
                    bucketArray.remove(key);
                }
                if (currentRow.features.size() > 0) {
                    rows.add(currentRow);
                    lastAllocatedCount = 0;
                }
                currentRow = new FeatureRow();
                nextStart = 0;
                lastKey = 0;
            }
            if (currentRow.features.size() > 0) {
                rows.add(currentRow);
            }
            return rows;
        }
    }

    static class FeatureRow {
        int start;
        int end;
        List<Feature> features = new ArrayList<Feature>(100);

        FeatureRow() {
        }

        void addFeature(Feature feature) {
            if (this.features.isEmpty()) {
                this.start = feature.getStart();
            }
            this.features.add(feature);
            this.end = feature.getEnd();
        }
    }
}

