/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class FeatureDirSource
implements FeatureSource {
    static Logger log = Logger.getLogger(FeatureDirSource.class);
    LRUCache<String, List<Feature>> featureCache = new LRUCache(this, 3);
    Properties fileMap;
    String rootDir;
    ResourceLocator rootLocator;
    boolean featuresLoading = false;

    public FeatureDirSource(ResourceLocator locator) throws IOException {
        this.rootLocator = locator;
        this.setRootDir(locator.getPath());
        this.fileMap = new Properties();
        InputStream propStream = ParsingUtils.openInputStream(locator);
        this.fileMap.load(propStream);
        propStream.close();
    }

    public List<Feature> getFeatures(final String chr) {
        String filename;
        List<Feature> features = this.featureCache.get(chr);
        if (features == null && (filename = this.fileMap.getProperty(chr)) != null && !this.featuresLoading) {
            this.featuresLoading = true;
            NamedRunnable runnable = new NamedRunnable(){
                AsciiLineReader reader = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String path = FeatureDirSource.this.rootDir + "/" + filename;
                    try {
                        log.info("Loading " + path);
                        ResourceLocator loc = new ResourceLocator(FeatureDirSource.this.rootLocator.getServerURL(), path);
                        FeatureParser fp = AbstractFeatureParser.getInstanceFor(loc);
                        this.reader = ParsingUtils.openAsciiReader(loc);
                        List<Feature> features = fp.loadFeatures(this.reader);
                        FeatureDirSource.this.featureCache.put(chr, features);
                        IGVMainFrame.getInstance().repaintDataPanels();
                    }
                    catch (IOException ex) {
                        MessageUtils.showMessage("Error loading file: " + path + " (" + ex.toString() + ")");
                        log.info("Error loading feature file: " + filename, ex);
                    }
                    finally {
                        if (this.reader != null) {
                            this.reader.close();
                        }
                        FeatureDirSource.this.featuresLoading = false;
                    }
                }

                @Override
                public String getName() {
                    return "FeatureDirSource.getFeatures()";
                }
            };
            runnable.run();
        }
        return this.featureCache.get(chr);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int i2, int i1, int zoom) {
        return null;
    }

    @Override
    public int getBinSize() {
        return 0;
    }

    @Override
    public void setBinSize(int size) {
    }

    @Override
    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        List<Feature> features = this.getFeatures(chr);
        return features == null ? null : features.iterator();
    }

    private void setRootDir(String path) {
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:")) {
            int idx = path.lastIndexOf(47);
            this.rootDir = path.substring(0, idx);
        } else {
            this.rootDir = new File(path).getParent();
        }
    }
}

