/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import jargs.gnu.CmdLineParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.SortingCollection;
import org.broad.igv.tools.CommandLineStatusMonitor;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.tools.sort.BedSorter;
import org.broad.igv.tools.sort.CNSorter;
import org.broad.igv.tools.sort.GFFSorter;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.tools.sort.SortableRecordCodec;
import org.broad.igv.tools.sort.SortedTxtSorter;
import org.broad.igv.tools.sort.VCFSorter;

public abstract class Sorter {
    static int MAX_RECORDS_IN_RAM = 500000;
    File inputFile;
    File outputFile;
    private int maxRecords;
    private File tmpDir;
    static final String usageString = "igvtools sort <inputFile> [outputFile]";
    StatusMonitor statusMonitor = new CommandLineStatusMonitor();

    public static Sorter getSorter(String[] argv) {
        if (argv.length < 2) {
            System.out.println(usageString);
            System.exit(-1);
        }
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option tmpDirOption = parser.addStringOption('t', "tmpDir");
        CmdLineParser.Option maxRecordsOption = parser.addStringOption('m', "maxRecords");
        try {
            parser.parse(argv);
        }
        catch (CmdLineParser.OptionException e2) {
            System.err.println("Error parsing command line " + e2.getMessage());
        }
        String[] nonOptionArgs = parser.getRemainingArgs();
        File inputFile = new File(nonOptionArgs[0]);
        if (!inputFile.exists()) {
            System.out.println("Error: " + inputFile.getAbsolutePath() + " does not exist.  Exiting");
            System.exit(-1);
        }
        File outputFile = new File(nonOptionArgs[1]);
        Sorter sorter = Sorter.getSorter(inputFile, outputFile);
        String tmpDirName = (String)parser.getOptionValue(tmpDirOption);
        if (tmpDirName != null) {
            File tmpDir = new File(tmpDirName);
            if (!tmpDir.exists()) {
                System.err.println("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                System.exit(-1);
            }
            sorter.setTmpDir(tmpDir);
        }
        int mr = MAX_RECORDS_IN_RAM;
        String maxRecordsString = (String)parser.getOptionValue(maxRecordsOption);
        if (maxRecordsOption != null) {
            try {
                mr = Integer.parseInt(maxRecordsString);
            }
            catch (NumberFormatException e3) {
                System.out.println("Warning: max records is not an integer: (" + maxRecordsString + ").  Setting" + "max records to " + MAX_RECORDS_IN_RAM);
                mr = MAX_RECORDS_IN_RAM;
            }
        }
        sorter.setMaxRecords(mr);
        return sorter;
    }

    public static Sorter getSorter(File inputFile, File outputFile) {
        String shortFN = inputFile.getName().toLowerCase();
        if (shortFN.endsWith(".txt")) {
            shortFN = shortFN.substring(0, shortFN.length() - 4);
        }
        if (shortFN.endsWith(".cn") || shortFN.endsWith(".xcn") || shortFN.endsWith(".snp") || shortFN.endsWith(".igv")) {
            return new CNSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sam")) {
            return new SAMSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".aligned") || shortFN.endsWith(".bed")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sorted")) {
            return new SortedTxtSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".gff") || shortFN.endsWith(".gff3")) {
            return new GFFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".vcf")) {
            return new VCFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".psl") || shortFN.endsWith(".pslx")) {
            return new BedSorter(inputFile, outputFile);
        }
        throw new PreprocessingException("Unknown file type or sorting not supported for: " + inputFile.getName());
    }

    public Sorter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileInputStream fis = null;
        PrintWriter writer = null;
        try {
            fis = new FileInputStream(this.inputFile);
            writer = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
            SortableRecordCodec codec = new SortableRecordCodec();
            Comparator<SortableRecord> comp = new Comparator<SortableRecord>(){

                @Override
                public int compare(SortableRecord o1, SortableRecord o2) {
                    String chr1 = o1.getChromosome().replaceFirst("chr", "");
                    String chr2 = o2.getChromosome().replaceFirst("chr", "");
                    int s1 = Integer.MAX_VALUE;
                    try {
                        s1 = Integer.parseInt(chr1);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    int s2 = Integer.MAX_VALUE;
                    try {
                        s2 = Integer.parseInt(chr2);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    int t1 = s1 - s2;
                    if (t1 == 0) {
                        chr1 = chr1.replace("M", "Z");
                        chr2 = chr2.replace("M", "Z");
                        t1 = chr1.compareTo(chr2);
                    }
                    if (t1 == 0) {
                        return o1.getStart() - o2.getStart();
                    }
                    return t1;
                }
            };
            SortingCollection<SortableRecord> cltn = SortingCollection.newInstance(SortableRecord.class, codec, comp, this.maxRecords, this.tmpDir);
            Parser parser = this.getParser();
            AsciiLineReader reader = new AsciiLineReader(fis);
            String firstDataRow = this.writeHeader(reader, writer);
            if (firstDataRow != null) {
                cltn.add(parser.createRecord(firstDataRow));
            }
            SortableRecord next = null;
            while ((next = parser.readNextRecord(reader)) != null) {
                cltn.add(next);
            }
            Iterator iter = cltn.iterator();
            while (iter.hasNext()) {
                SortableRecord al = (SortableRecord)iter.next();
                writer.println(al.getText());
            }
            iter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fis.close();
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    abstract Parser getParser();

    abstract String writeHeader(AsciiLineReader var1, PrintWriter var2);

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }
}

