/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class UCSCUtils {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage convertWIGVile <txtFile> <wibFile> <wigFile> [trackLine options]");
            System.exit(-1);
        }
        File txtFile = new File(args[0]);
        File wibFile = new File(args[1]);
        File wigFile = new File(args[2]);
        String trackLine = null;
        if (args.length > 3) {
            trackLine = "track";
            for (int i2 = 3; i2 < args.length; ++i2) {
                trackLine = trackLine + " " + args[i2];
            }
        }
        UCSCUtils.convertWIBFile(txtFile, wibFile, wigFile, trackLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertWIBFile(File txtFile, File wibFile, File wigFile, String trackLine) {
        BufferedReader txtReader = null;
        FileInputStream dataInputStream = null;
        PrintWriter wigWriter = null;
        String lastChr = "";
        int lastSpan = -1;
        try {
            String nextLine;
            txtReader = new BufferedReader(new FileReader(txtFile));
            dataInputStream = new FileInputStream(wibFile);
            wigWriter = new PrintWriter(new BufferedWriter(new FileWriter(wigFile)));
            if (trackLine != null) {
                wigWriter.println(trackLine);
            }
            while ((nextLine = txtReader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[1];
                int start = Integer.parseInt(tokens[2]) + 1;
                int span = Integer.parseInt(tokens[5]);
                if (!chr.equals(lastChr) || span != lastSpan) {
                    System.out.println("variableStep chrom=" + chr + " span=" + span);
                    wigWriter.println("variableStep chrom=" + chr + " span=" + span);
                    lastChr = chr;
                    lastSpan = span;
                }
                int count = Integer.parseInt(tokens[6]);
                byte[] data = new byte[count];
                Integer offset = Integer.parseInt(tokens[7]);
                dataInputStream.getChannel().position(offset.intValue());
                DataInputStream dis = new DataInputStream(dataInputStream);
                dis.readFully(data);
                double lowerLimit = Double.parseDouble(tokens[9]);
                double dataRange = Double.parseDouble(tokens[10]);
                int chromPosition = start;
                int i2 = 0;
                while (i2 < count) {
                    if (data[i2] < 128) {
                        double value = lowerLimit + dataRange * ((double)data[i2] / 127.0);
                        wigWriter.println(chromPosition + "\t" + value);
                    }
                    ++i2;
                    chromPosition += span;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                txtReader.close();
                dataInputStream.close();
                wigWriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

