/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.broad.igv.Globals;
import org.broad.igv.data.seg.SegmentedDataWriter;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.tools.TestFileGenerator;
import org.broad.igv.tools.UCSCUtils;
import org.broad.igv.tools.parsers.GCTtoIGVConverter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.track.tribble.CodecFactory;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.linear.LinearIndexCreator;

public class IgvTools {
    static String version = "1.5.10";
    static String[] commandDocs = new String[]{"version print the version number", "sort    sort an alignment file by start position", "index   index an alignment file", "tile    convert an input file (cn, gct, wig) to tiled data format (tdf)", "count   compute coverage density for an alignment file"};
    static final int MAX_RECORDS_IN_RAM = 500000;
    static final int MAX_ZOOM = 7;
    static final int WINDOW_SIZE = 25;
    static final int EXT_FACTOR = 0;
    static final Object PROBE_FILE = null;
    static final int LINEAR_BIN_SIZE = 16000;
    static final int INTERVAL_SIZE = 1000;
    static final int LINEAR_INDEX = 1;
    static final int INTERVAL_INDEX = 2;

    static String usageString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nProgram: igvtools\n\n");
        buf.append("Usage: igvtools [command] [options] [arguments]\n\n");
        buf.append("Command:");
        for (String c2 : commandDocs) {
            buf.append(" " + c2 + "\n\t");
        }
        return buf.toString();
    }

    public static void main(String[] argv) throws IOException, PreprocessingException {
        block20: {
            Globals.setHeadless(true);
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
            CmdLineParser.Option guiOption = parser.addBooleanOption('g', "gui");
            CmdLineParser.Option windowFunctions = parser.addStringOption('f', "windowFunctions");
            CmdLineParser.Option tmpDirOption = parser.addStringOption('t', "tmpDir");
            CmdLineParser.Option probeFileOption = parser.addStringOption('p', "probeFile");
            CmdLineParser.Option maxZoomOption = parser.addIntegerOption('z', "maxZoom");
            CmdLineParser.Option compressOption = parser.addBooleanOption('c', "compressed");
            CmdLineParser.Option maxRecordsOption = parser.addIntegerOption('m', "maxRecords");
            CmdLineParser.Option windowSizeOption = parser.addIntegerOption('w', "windowSize");
            CmdLineParser.Option extFactorOption = parser.addIntegerOption('e', "extFactor");
            CmdLineParser.Option indexTypeOption = parser.addIntegerOption('i', "indexType");
            CmdLineParser.Option binSizeOption = parser.addIntegerOption('b', "binSize");
            CmdLineParser.Option nRows = parser.addIntegerOption('r', "numRows");
            CmdLineParser.Option strandOption = parser.addIntegerOption('s', "strand");
            CmdLineParser.Option unOrdered = parser.addBooleanOption('u', "unOrdered");
            try {
                parser.parse(argv);
            }
            catch (CmdLineParser.OptionException e2) {
                System.err.println(e2.getMessage());
                return;
            }
            boolean help = (Boolean)parser.getOptionValue(helpOption, false);
            if (argv.length < 1 || help) {
                System.out.println(IgvTools.usageString());
                return;
            }
            boolean gui = (Boolean)parser.getOptionValue(guiOption, false);
            if (gui) {
                IgvTools.launchGUI();
                Runtime.getRuntime().halt(0);
            }
            int maxZoomValue = (Integer)parser.getOptionValue(maxZoomOption, 7);
            int windowSizeValue = (Integer)parser.getOptionValue(windowSizeOption, 25);
            int extFactorValue = (Integer)parser.getOptionValue(extFactorOption, 0);
            String wfsString = (String)parser.getOptionValue(windowFunctions);
            String probeFile = (String)parser.getOptionValue(probeFileOption, PROBE_FILE);
            String tmpDirName = (String)parser.getOptionValue(tmpDirOption);
            int maxRecords = (Integer)parser.getOptionValue(maxRecordsOption, 500000);
            int strandOptionValue = (Integer)parser.getOptionValue(strandOption, -1);
            int indexType = (Integer)parser.getOptionValue(indexTypeOption, 1);
            int defaultBinSize = indexType == 1 ? 16000 : 1000;
            int binSize = (Integer)parser.getOptionValue(binSizeOption, defaultBinSize);
            int nRowsValue = (Integer)parser.getOptionValue(nRows, 10);
            boolean sorted = (Boolean)parser.getOptionValue(unOrdered, false) == false;
            String[] nonOptionArgs = parser.getRemainingArgs();
            try {
                IgvTools.validateArgsLength(nonOptionArgs, 1);
                String command = nonOptionArgs[0].toLowerCase();
                if (command.equals("version")) {
                    System.out.println("Version " + version);
                    return;
                }
                IgvTools.validateArgsLength(nonOptionArgs, 2);
                String ifile = nonOptionArgs[1];
                if (!new File(ifile).exists()) {
                    throw new PreprocessingException("File not found: " + ifile);
                }
                if (command.equals("count") || command.equals("pre") || command.equals("tile")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 4);
                    String ofile = nonOptionArgs[2];
                    String genomeId = nonOptionArgs[3];
                    boolean isGCT = Preprocessor.getExtension(ifile).endsWith("gct");
                    Collection<WindowFunction> wfList = IgvTools.parseWFS(wfsString, isGCT);
                    if (command.equals("count")) {
                        IgvTools.doCount(ifile, ofile, genomeId, maxZoomValue, wfList, windowSizeValue, extFactorValue, strandOptionValue);
                    } else {
                        IgvTools.doTile(ifile, ofile, probeFile, genomeId, maxZoomValue, wfList);
                    }
                    break block20;
                }
                if (command.toLowerCase().equals("sort")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 3);
                    String ofile = nonOptionArgs[2];
                    IgvTools.doSort(ifile, ofile, tmpDirName, maxRecords);
                    break block20;
                }
                if (command.equals("index")) {
                    IgvTools.doIndex(ifile, indexType, binSize);
                    break block20;
                }
                if (command.equals("seg")) {
                    IgvTools.doPreprocessSeg(argv);
                    break block20;
                }
                if (command.equals("wibtowig")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 4);
                    File txtFile = new File(nonOptionArgs[1]);
                    File wibFile = new File(nonOptionArgs[2]);
                    File wigFile = new File(nonOptionArgs[3]);
                    String trackLine = nonOptionArgs.length > 4 ? nonOptionArgs[4] : null;
                    IgvTools.doWIBtoWIG(txtFile, wibFile, wigFile, trackLine);
                    break block20;
                }
                if (command.equals("splitgff")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 3);
                    String outputDirectory = nonOptionArgs[2];
                    GFFParser.splitFileByType(ifile, outputDirectory);
                    break block20;
                }
                if (command.equals("gentest")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 2);
                    String ofile = ifile;
                    TestFileGenerator.generateTestFile(ofile, sorted, nRowsValue, strandOptionValue);
                    break block20;
                }
                if (command.toLowerCase().equals("gcttoigv")) {
                    IgvTools.validateArgsLength(nonOptionArgs, 4);
                    String ofile = nonOptionArgs[2];
                    if (!ofile.endsWith(".igv")) {
                        ofile = ofile + ".igv";
                    }
                    String genomeId = nonOptionArgs[3];
                    IgvTools.doGCTtoIGV(ifile, ofile, probeFile, genomeId);
                    break block20;
                }
                throw new PreprocessingException("Unknown command: " + argv[0]);
            }
            catch (PreprocessingException e3) {
                System.err.println(e3.getMessage());
            }
            catch (IOException e4) {
                throw new PreprocessingException("Unexpected IO error: ", e4);
            }
        }
    }

    private static void doGCTtoIGV(String ifile, String ofile, String probefile, String genomeId) throws IOException {
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        GCTtoIGVConverter.convert(new File(ifile), new File(ofile), probefile, genomeId);
    }

    public static void doTile(String ifile, String ofile, String probeFile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions) throws IOException, PreprocessingException {
        IgvTools.validateIsTilable(ifile);
        System.out.println("Tile.  File = " + ifile);
        System.out.println("Max zoom = " + maxZoomValue);
        if (probeFile != null && probeFile.trim().length() > 0) {
            System.out.println("Probe file = " + probeFile);
        }
        System.out.print("Window functions: ");
        for (WindowFunction wf : windowFunctions) {
            System.out.print(wf.toString() + " ");
        }
        System.out.println();
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        File tmp = new File(ifile);
        int nLines = tmp.isDirectory() ? 310000000 : ParsingUtils.estimateLineCount(ifile);
        Preprocessor p2 = new Preprocessor(new File(ofile), genome, windowFunctions, nLines, null);
        if (tmp.isDirectory()) {
            for (File f2 : tmp.listFiles()) {
                p2.preprocess(f2, probeFile, maxZoomValue);
            }
        } else {
            p2.preprocess(tmp, probeFile, maxZoomValue);
        }
        p2.finish();
        System.out.flush();
    }

    public static void doCount(String ifile, String ofile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions, int windowSizeValue, int extFactorValue, int strandOption) throws IOException {
        System.out.println("Computing coverage.  File = " + ifile);
        System.out.println("Max zoom = " + maxZoomValue);
        System.out.println("Window size = " + windowSizeValue);
        System.out.print("Window functions: ");
        for (WindowFunction wf : windowFunctions) {
            System.out.print(wf.toString() + " ");
        }
        System.out.println();
        System.out.println("Ext factor = " + extFactorValue);
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        int nLines = ParsingUtils.estimateLineCount(ifile);
        File tdfFile = null;
        File wigFile = null;
        String[] files = ofile.split(",");
        if (files[0].endsWith("wig")) {
            wigFile = new File(files[0]);
        } else {
            tdfFile = new File(files[0]);
        }
        if (files.length > 1) {
            if (files[1].endsWith("wig")) {
                wigFile = new File(files[1]);
            } else if (files[1].endsWith("tdf")) {
                tdfFile = new File(files[1]);
            }
        }
        if (tdfFile != null && !tdfFile.getName().endsWith(".tdf")) {
            tdfFile = new File(tdfFile.getAbsolutePath() + ".tdf");
        }
        Preprocessor p2 = new Preprocessor(tdfFile, genome, windowFunctions, nLines, null);
        p2.count(ifile, windowSizeValue, extFactorValue, maxZoomValue, wigFile, strandOption);
        p2.finish();
        System.out.flush();
    }

    public static void doWIBtoWIG(File txtFile, File wibFile, File wigFile, String trackLine) {
        UCSCUtils.convertWIBFile(txtFile, wibFile, wigFile, trackLine);
    }

    public static void doPreprocessSeg(String[] argv) {
        int nArgs = argv.length - 1;
        String[] args = new String[nArgs];
        System.arraycopy(argv, 1, args, 0, nArgs);
        SegmentedDataWriter.main(args);
    }

    public static void doIndex(String ifile, int indexType, int binSize) throws IOException {
        if (ifile.endsWith(".gz")) {
            System.out.println("Cannot index a gzipped file");
            throw new PreprocessingException("Cannot index a gzipped file");
        }
        File inputFile = new File(ifile);
        if (ifile.endsWith(".bed") || ifile.endsWith(".vcf") || ifile.endsWith(".gff") || ifile.endsWith(".gff3") || ifile.endsWith(".psl") || ifile.endsWith(".pslx")) {
            FeatureCodec codec = CodecFactory.getCodec(ifile);
            IndexCreator indexer = null;
            if (indexType == 1) {
                LinearIndexCreator c2 = new LinearIndexCreator(inputFile, codec);
                c2.setBinWidth(binSize);
                indexer = c2;
            } else {
                IntervalIndexCreator c3 = new IntervalIndexCreator(inputFile, codec);
                c3.setFeaturesPerInterval(binSize);
                indexer = c3;
            }
            indexer.createIndex();
        } else {
            AlignmentIndexer indexer = AlignmentIndexer.getInstance(inputFile, null, null);
            indexer.createSamIndex();
        }
        System.out.flush();
    }

    public static void doSort(String ifile, String ofile, String tmpDirName, int maxRecords) {
        System.out.println("Sorting " + ifile);
        File inputFile = new File(ifile);
        File outputFile = new File(ofile);
        Sorter sorter = Sorter.getSorter(inputFile, outputFile);
        if (tmpDirName != null && tmpDirName.trim().length() > 0) {
            File tmpDir = new File(tmpDirName);
            if (!tmpDir.exists()) {
                System.err.println("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                throw new PreprocessingException("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
            }
            sorter.setTmpDir(tmpDir);
        }
        sorter.setMaxRecords(maxRecords);
        sorter.run();
        System.out.println("Done");
        System.out.flush();
    }

    private static void validateArgsLength(String[] nonOptionArgs, int len) throws PreprocessingException {
        if (nonOptionArgs.length < len) {
            throw new PreprocessingException(IgvTools.usageString());
        }
    }

    public static Genome loadGenome(String genomeFileOrID) {
        String rootDir = FileUtils.getInstallDirectory();
        Genome genome = GenomeManager.getInstance().getGenome(genomeFileOrID);
        if (genome != null) {
            return genome;
        }
        File genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID + ".genome");
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID);
        }
        if (!genomeFile.exists()) {
            genomeFile = new File(genomeFileOrID);
        }
        if (!genomeFile.exists()) {
            throw new PreprocessingException("Genome definition file not found for: " + genomeFileOrID);
        }
        GenomeManager.GenomeListItem item = GenomeManager.getInstance().loadGenomeFromLocalFile(genomeFile);
        String genomeId = item.getId();
        if (genomeId == null) {
            throw new PreprocessingException("Error loading: " + genomeFileOrID);
        }
        ViewContext.getInstance().setGenomeId(genomeId);
        genome = GenomeManager.getInstance().getGenome(genomeId);
        return genome;
    }

    private static void validateIsTilable(String ifile) {
        String ext;
        File tmp = new File(ifile);
        if (tmp.isDirectory()) {
            File[] files = tmp.listFiles();
            if (files.length == 0) {
                throw new PreprocessingException("Tile command not supported for empty directory: " + ifile);
            }
            ifile = files[0].getName();
        }
        if (!((ext = Preprocessor.getExtension(ifile)).equals(".cn") || ext.equals(".igv") || ext.equals(".wig") || ext.equals(".ewig") || ext.equals(".cn") || ext.equals(".snp") || ext.equals(".xcn") || ext.equals(".gct") || ext.equals(".bedgraph") || Preprocessor.isAlignmentFile(ext))) {
            throw new PreprocessingException("Tile command not supported for files of type: " + ext);
        }
    }

    private static Collection<WindowFunction> parseWFS(String string, boolean isGCT) {
        if (string == null || string.length() == 0) {
            return isGCT ? Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max) : Arrays.asList(WindowFunction.mean);
        }
        String[] tokens = string.split(",");
        ArrayList<WindowFunction> funcs = new ArrayList<WindowFunction>(tokens.length);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String wf = tokens[i2];
            if (wf.startsWith("p")) {
                wf = wf.replaceFirst("p", "percentile");
            }
            try {
                funcs.add(WindowFunction.valueOf(wf));
                continue;
            }
            catch (Exception e2) {
                System.err.println("Unrecognized window function: " + tokens[i2]);
            }
        }
        return funcs;
    }

    private static void launchGUI() {
        IgvToolsGui.main(null);
    }
}

