/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.tools.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;

public class Bin
implements LocusScore {
    private int start;
    private int end;
    private float score = Float.MIN_VALUE;
    Accumulator accumulator;
    FloatArrayList values;
    List<String> names;
    WindowFunction windowFunction;
    private static final int maxValues = 5;

    public Bin(int start, int end, String probeName, float initialValue, WindowFunction windowFunction) {
        this.start = start;
        this.end = end;
        this.values = new FloatArrayList(5);
        this.accumulator = new Accumulator(Arrays.asList(windowFunction));
        this.windowFunction = windowFunction;
        this.addValue(probeName, initialValue);
    }

    public Bin(Bin otherBin) {
        this.start = otherBin.start;
        this.end = otherBin.end;
        this.accumulator = otherBin.accumulator;
        this.names = otherBin.names;
        this.score = otherBin.score;
        this.windowFunction = otherBin.windowFunction;
    }

    public boolean isExtension(Bin bin) {
        return this.end == bin.start && this.getScore() == bin.getScore();
    }

    public void addValue(String name, float value) {
        if (this.values.size() < 5) {
            if (name != null) {
                if (this.names == null) {
                    this.names = new ArrayList<String>(5);
                }
                this.names.add(name);
            }
            this.values.add(value);
        }
        this.accumulator.add(value);
    }

    public String getChr() {
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public float getScore() {
        if (this.score == Float.MIN_VALUE) {
            this.computeScore();
        }
        return this.score;
    }

    private void computeScore() {
        if (this.accumulator == null) {
            this.score = Float.NaN;
        } else {
            this.accumulator.finish();
            this.score = this.accumulator.getValue(this.windowFunction);
        }
    }

    @Override
    public void setConfidence(float confidence) {
    }

    @Override
    public float getConfidence() {
        return 1.0f;
    }

    @Override
    public LocusScore copy() {
        return new Bin(this);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuffer sb = new StringBuffer(50);
        sb.append("Value: ");
        sb.append(String.valueOf(this.getScore()));
        if (this.values.size() == 1) {
            if (this.names != null && this.names.size() > 0) {
                sb.append(" (");
                sb.append(this.names.get(0));
                sb.append(")");
            }
        } else {
            sb.append("<br> ");
            sb.append(windowFunction.getDisplayName() + " of " + (this.values.size() == 5 ? "> " : "") + this.values.size() + " values:");
            float[] v = this.values.toArray();
            for (int i2 = 0; i2 < v.length; ++i2) {
                sb.append("<br>   " + v[i2]);
                if (this.names == null || this.names.size() <= i2) continue;
                sb.append("  (");
                sb.append(this.names.get(i2));
                sb.append(")");
            }
            if (v.length == 5) {
                sb.append("<br>...");
            }
        }
        return sb.toString();
    }
}

