/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.Session;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.FilterElement;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static Logger log = Logger.getLogger(SessionReader.class);
    private static String INPUT_FILE_KEY = "INPUT_FILE_KEY";
    private Collection<ResourceLocator> dataFiles;
    private Collection<ResourceLocator> missingDataFiles;
    private static Map<String, String> attributeSynonymMap = new HashMap<String, String>();
    private boolean panelElementPresent = false;
    private int version;
    Map<String, List<Track>> trackDictionary = new LinkedHashMap<String, List<Track>>();

    public Session loadSession(InputStream inputStream, Session session, String sessionName) throws RuntimeException {
        log.debug("Load session");
        Document document = null;
        try {
            document = this.createDOMDocumentFromXmlFile(inputStream);
        }
        catch (Exception e2) {
            log.error("Session Management Error", e2);
            throw new RuntimeException(e2);
        }
        HashMap<String, String> additionalInformation = new HashMap<String, String>();
        additionalInformation.put(INPUT_FILE_KEY, sessionName);
        NodeList nodes = document.getElementsByTagName(SessionElement.GLOBAL.getText());
        if (nodes == null || nodes.getLength() == 0) {
            nodes = document.getElementsByTagName(SessionElement.SESSION.getText());
        }
        this.processRootNode(session, nodes.item(0), additionalInformation);
        this.addLeftoverTracks(this.trackDictionary.values());
        if (session.getGroupTracksBy() != null && session.getGroupTracksBy().length() > 0) {
            IGVMainFrame.getInstance().getTrackManager().setGroupByAttribute(session.getGroupTracksBy());
        }
        IGVMainFrame.getInstance().getTrackManager().resetOverlayTracks();
        return session;
    }

    private void addLeftoverTracks(Collection<List<Track>> tmp) {
        if (this.version < 3 || !this.panelElementPresent) {
            for (List<Track> tracks : tmp) {
                for (Track track : tracks) {
                    TrackPanel group = IGVMainFrame.getInstance().getTrackManager().getPanelFor(new ResourceLocator(track.getSourceFile()));
                    group.addTrack(track);
                }
            }
        }
    }

    private void process(Session session, Node element, HashMap additionalInformation) {
        if (element == null || session == null) {
            return;
        }
        String nodeName = element.getNodeName();
        if (nodeName.equalsIgnoreCase(SessionElement.GLOBAL.getText()) || nodeName.equalsIgnoreCase(SessionElement.SESSION.getText())) {
            this.processGlobal(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILES.getText())) {
            this.processFiles(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.DATA_FILE.getText())) {
            this.processDataFile(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.RESOURCES.getText())) {
            this.processResources(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.RESOURCE.getText())) {
            this.processResource(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGIONS.getText())) {
            this.processRegions(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.REGION.getText())) {
            this.processRegion(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER.getText())) {
            this.processFilter(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.FILTER_ELEMENT.getText())) {
            this.processFilterElement(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALES.getText())) {
            this.processColorScales(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.COLOR_SCALE.getText())) {
            this.processColorScale(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PREFERENCES.getText())) {
            this.processPreferences(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.PROPERTY.getText())) {
            this.processPreference(session, (Element)element, additionalInformation);
        } else if (nodeName.equalsIgnoreCase(SessionElement.DATA_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.FEATURE_TRACKS.getText()) || nodeName.equalsIgnoreCase(SessionElement.PANEL.getText())) {
            this.processPanel(session, (Element)element, additionalInformation);
        }
    }

    private void processRootNode(Session session, Node element, HashMap additionalInformation) {
        if (element == null || session == null) {
            return;
        }
        String nodeName = element.getNodeName();
        if (!nodeName.equalsIgnoreCase(SessionElement.GLOBAL.getText()) && !nodeName.equalsIgnoreCase(SessionElement.SESSION.getText())) {
            MessageUtils.showMessage("Session files must begin with a \"Global\" or \"Session\" element.  Found: " + nodeName);
        }
        this.process(session, element, additionalInformation);
    }

    private void processGlobal(Session session, Element element, HashMap additionalInformation) {
        IGVMainFrame.getInstance().selectGenomeFromList(this.getAttribute(element, SessionAttribute.GENOME.getText()));
        session.setLocus(this.getAttribute(element, SessionAttribute.LOCUS.getText()));
        session.setGroupTracksBy(this.getAttribute(element, SessionAttribute.GROUP_TRACKS_BY.getText()));
        String versionString = this.getAttribute(element, SessionAttribute.VERSION.getText());
        try {
            this.version = Integer.parseInt(versionString);
        }
        catch (NumberFormatException e2) {
            log.error("Non integer version number in session file: " + versionString);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processFiles(Session session, Element element, HashMap additionalInformation) {
        this.dataFiles = new ArrayList<ResourceLocator>();
        this.missingDataFiles = new ArrayList<ResourceLocator>();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        if (this.missingDataFiles.size() > 0) {
            StringBuffer message = new StringBuffer();
            message.append("<html>The following data file(s) could not be located.<ul>");
            for (ResourceLocator file : this.missingDataFiles) {
                if (file.isLocal()) {
                    message.append("<li>");
                    message.append(file.getPath());
                    message.append("</li>");
                    continue;
                }
                message.append("<li>Server: ");
                message.append(file.getServerURL());
                message.append("  Path: ");
                message.append(file.getPath());
                message.append("</li>");
            }
            message.append("</ul>");
            message.append("Common reasons for this include: ");
            message.append("<ul><li>The session or data files have been moved.</li> ");
            message.append("<li>The data files are located on a drive that is not currently accessible.</li></ul>");
            message.append("</html>");
            MessageUtils.showMessage(message.toString());
        }
        if (this.dataFiles.size() > 0) {
            TrackLoader loader = new TrackLoader();
            for (ResourceLocator locator : this.dataFiles) {
                try {
                    List<Track> tracks = loader.load(locator);
                    if (tracks.size() > 0) {
                        for (Track track : tracks) {
                            String id = this.version < 3 ? track.getId_142() : track.getId();
                            List<Track> trackList = this.trackDictionary.get(id);
                            if (trackList == null) {
                                trackList = new ArrayList<Track>();
                                this.trackDictionary.put(id, trackList);
                            }
                            trackList.add(track);
                            track.setAttributeValue("DATA FILE", locator.getPath());
                            track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
                        }
                        continue;
                    }
                    AttributeManager.getInstance().loadSampleInfo(locator);
                }
                catch (Exception e2) {
                    log.error("Error loading " + locator.getPath(), e2);
                    MessageUtils.showMessage("<html>Error loading: " + locator.getPath() + "<br>" + e2.toString());
                }
            }
        }
        this.dataFiles = null;
    }

    private void processDataFile(Session session, Element element, HashMap additionalInformation) {
        ResourceLocator resourceLocator = null;
        String serverURL = this.getAttribute(element, SessionAttribute.SERVER_URL.getText());
        String filePath = this.getAttribute(element, SessionAttribute.NAME.getText());
        String resourceType = this.getAttribute(element, SessionAttribute.RESOURCE_TYPE.getText());
        if (!(serverURL != null && !serverURL.trim().equals("") || filePath.startsWith("http:") || filePath.startsWith("https:") || filePath.startsWith("file:"))) {
            String relPathValue = this.getAttribute(element, SessionAttribute.RELATIVE_PATH.getText());
            boolean relativePaths = relPathValue != null && relPathValue.equalsIgnoreCase("true");
            File parent = relativePaths ? new File(session.getPath()).getParentFile() : null;
            File file = new File(parent, filePath);
            resourceLocator = new ResourceLocator(file.getAbsolutePath());
        } else {
            resourceLocator = new ResourceLocator(serverURL, filePath);
        }
        if (resourceType != null) {
            resourceLocator.setType(resourceType);
        }
        if (resourceLocator.exists()) {
            this.dataFiles.add(resourceLocator);
        } else {
            this.missingDataFiles.add(resourceLocator);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processResources(Session session, Element element, HashMap additionalInformation) {
        this.processFiles(session, element, additionalInformation);
    }

    private void processResource(Session session, Element element, HashMap additionalInformation) {
        String url;
        String label = this.getAttribute(element, SessionAttribute.LABEL.getText());
        String name = this.getAttribute(element, SessionAttribute.NAME.getText());
        String sampleId = this.getAttribute(element, SessionAttribute.SAMPLE_ID.getText());
        String description = this.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        String type = this.getAttribute(element, SessionAttribute.TYPE.getText());
        String coverage = this.getAttribute(element, SessionAttribute.COVERAGE.getText());
        String trackLine = this.getAttribute(element, SessionAttribute.TRACK_LINE.getText());
        String colorString = this.getAttribute(element, SessionAttribute.COLOR.getText());
        String relPathValue = this.getAttribute(element, SessionAttribute.RELATIVE_PATH.getText());
        boolean relativePaths = relPathValue != null && relPathValue.equalsIgnoreCase("true");
        String serverURL = this.getAttribute(element, SessionAttribute.SERVER_URL.getText());
        String path = this.getAttribute(element, SessionAttribute.PATH.getText());
        ResourceLocator resourceLocator = new ResourceLocator(serverURL, path);
        if (relativePaths) {
            if (FileUtils.isRemote(session.getPath())) {
                int idx = session.getPath().lastIndexOf("/");
                String basePath = session.getPath().substring(0, idx);
                String resPath = basePath + "/" + path;
                resourceLocator = new ResourceLocator(serverURL, resPath);
            } else {
                File parent = relativePaths ? new File(session.getPath()).getParentFile() : null;
                File file = new File(parent, path);
                resourceLocator = new ResourceLocator(serverURL, file.getAbsolutePath());
            }
        }
        if ((url = this.getAttribute(element, SessionAttribute.URL.getText())) == null) {
            url = this.getAttribute(element, SessionAttribute.FEATURE_URL.getText());
        }
        resourceLocator.setUrl(url);
        String infolink = this.getAttribute(element, SessionAttribute.HYPERLINK.getText());
        if (infolink == null) {
            infolink = this.getAttribute(element, SessionAttribute.INFOLINK.getText());
        }
        resourceLocator.setInfolink(infolink);
        if (name != null) {
            resourceLocator.setName(name);
        } else {
            resourceLocator.setName(label);
        }
        resourceLocator.setSampleId(sampleId);
        resourceLocator.setDescription(description);
        if (type != null && !type.equals("local")) {
            resourceLocator.setType(type);
        }
        resourceLocator.setCoverage(coverage);
        resourceLocator.setTrackLine(trackLine);
        if (colorString != null) {
            try {
                Color c2 = ColorUtilities.getColorFromString(colorString);
                resourceLocator.setColor(c2);
            }
            catch (Exception e2) {
                log.error("Error setting color: ", e2);
            }
        }
        if (resourceLocator.exists()) {
            this.dataFiles.add(resourceLocator);
        } else {
            this.missingDataFiles.add(resourceLocator);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processRegions(Session session, Element element, HashMap additionalInformation) {
        session.clearRegionsOfInterest();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processRegion(Session session, Element element, HashMap additionalInformation) {
        String chromosome = this.getAttribute(element, SessionAttribute.CHROMOSOME.getText());
        String start = this.getAttribute(element, SessionAttribute.START_INDEX.getText());
        String end = this.getAttribute(element, SessionAttribute.END_INDEX.getText());
        String description = this.getAttribute(element, SessionAttribute.DESCRIPTION.getText());
        RegionOfInterest region = new RegionOfInterest(chromosome, new Integer(start), new Integer(end), description);
        IGVMainFrame.getInstance().addRegionOfInterest(region);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processFilter(Session session, Element element, HashMap additionalInformation) {
        String match = this.getAttribute(element, SessionAttribute.FILTER_MATCH.getText());
        String showAllTracks = this.getAttribute(element, SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText());
        String filterName = this.getAttribute(element, SessionAttribute.NAME.getText());
        TrackFilter filter = new TrackFilter(filterName, null);
        additionalInformation.put(SessionElement.FILTER, filter);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        session.setFilter(filter);
        if ("all".equalsIgnoreCase(match)) {
            IGVMainFrame.getInstance().setFilterMatchAll(true);
        } else if ("any".equalsIgnoreCase(match)) {
            IGVMainFrame.getInstance().setFilterMatchAll(false);
        }
        if ("true".equalsIgnoreCase(showAllTracks)) {
            IGVMainFrame.getInstance().setFilterShowAllTracks(true);
        } else {
            IGVMainFrame.getInstance().setFilterShowAllTracks(false);
        }
    }

    private void processFilterElement(Session session, Element element, HashMap additionalInformation) {
        TrackFilter filter = (TrackFilter)additionalInformation.get((Object)SessionElement.FILTER);
        String item = this.getAttribute(element, SessionAttribute.ITEM.getText());
        String operator = this.getAttribute(element, SessionAttribute.OPERATOR.getText());
        String value = this.getAttribute(element, SessionAttribute.VALUE.getText());
        String booleanOperator = this.getAttribute(element, SessionAttribute.BOOLEAN_OPERATOR.getText());
        TrackFilterElement trackFilterElement = new TrackFilterElement(filter, item, FilterElement.Operator.findEnum(operator), value, FilterElement.BooleanOperator.findEnum(booleanOperator));
        filter.add(trackFilterElement);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processPanel(Session session, Element element, HashMap additionalInformation) {
        String nodeName;
        this.panelElementPresent = true;
        String panelName = nodeName = element.getNodeName();
        int height = 0;
        int width = 0;
        if (nodeName.equalsIgnoreCase(SessionElement.PANEL.getText())) {
            panelName = element.getAttribute("name");
            try {
                height = Integer.valueOf(element.getAttribute("height"));
                width = Integer.valueOf(element.getAttribute("width"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ArrayList<Track> panelTracks = new ArrayList<Track>();
        NodeList elements = element.getChildNodes();
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            if (childNode.getNodeName().equalsIgnoreCase(SessionElement.DATA_TRACK.getText()) || childNode.getNodeName().equalsIgnoreCase(SessionElement.TRACK.getText())) {
                List<Track> tracks = this.processTrack(session, (Element)childNode, additionalInformation);
                if (tracks == null) continue;
                panelTracks.addAll(tracks);
                continue;
            }
            this.process(session, childNode, additionalInformation);
        }
        TrackPanel panel = IGVMainFrame.getInstance().getDataPanel(panelName);
        if (height == 0) {
            height = panel.getPreferredPanelHeight();
        }
        if (width == 0) {
            width = panel.getViewportWidth();
        }
        panel.setHeight(height);
        panel.addTracks(panelTracks);
    }

    private List<Track> processTrack(Session session, Element element, HashMap additionalInformation) {
        List<Track> matchedTracks;
        String id = this.getAttribute(element, SessionAttribute.ID.getText());
        HashMap<String, String> tAttributes = new HashMap<String, String>();
        HashMap<String, String> drAttributes = new HashMap<String, String>();
        NamedNodeMap tNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < tNodeMap.getLength(); ++i2) {
            Node node = tNodeMap.item(i2);
            String value = node.getNodeValue();
            if (value == null || value.length() <= 0) continue;
            tAttributes.put(node.getNodeName(), value);
        }
        if (element.hasChildNodes()) {
            Node childNode = element.getFirstChild();
            Node sibNode = childNode.getNextSibling();
            NamedNodeMap drNodeMap = sibNode.getAttributes();
            for (int i3 = 0; i3 < drNodeMap.getLength(); ++i3) {
                Node node = drNodeMap.item(i3);
                String value = node.getNodeValue();
                if (value == null || value.length() <= 0) continue;
                drAttributes.put(node.getNodeName(), value);
            }
        }
        if ((matchedTracks = this.trackDictionary.get(id)) == null) {
            log.info("Warning.  No tracks were found with id: " + id + " in session file");
        } else {
            for (Track track : matchedTracks) {
                track.restorePersistentState(tAttributes);
                DataRange dr = track.getDataRange();
                dr.restorePersistentState(drAttributes);
                track.setDataRange(dr);
            }
            this.trackDictionary.remove(id);
        }
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
        return matchedTracks;
    }

    private void processColorScales(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processColorScale(Session session, Element element, HashMap additionalInformation) {
        String trackType = this.getAttribute(element, SessionAttribute.TYPE.getText());
        String value = this.getAttribute(element, SessionAttribute.VALUE.getText());
        this.setColorScaleSet(session, trackType, value);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processPreferences(Session session, Element element, HashMap additionalInformation) {
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void processPreference(Session session, Element element, HashMap additionalInformation) {
        String name = this.getAttribute(element, SessionAttribute.NAME.getText());
        String value = this.getAttribute(element, SessionAttribute.VALUE.getText());
        session.setPreference(name, value);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, additionalInformation);
    }

    private void process(Session session, NodeList elements, HashMap additionalInformation) {
        for (int i2 = 0; i2 < elements.getLength(); ++i2) {
            Node childNode = elements.item(i2);
            this.process(session, childNode, additionalInformation);
        }
    }

    private Document createDOMDocumentFromXmlFile(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDocument = documentBuilder.parse(inputStream);
        return xmlDocument;
    }

    public void setColorScaleSet(Session session, String type, String value) {
        if (type == null | value == null) {
            return;
        }
        TrackType trackType = TrackType.OTHER;
        if (TrackType.ALLELE_SPECIFIC_COPY_NUMBER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
        } else if (TrackType.CHIP.name().equalsIgnoreCase(type)) {
            trackType = TrackType.CHIP;
        } else if (TrackType.COPY_NUMBER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.COPY_NUMBER;
        } else if (TrackType.DNA_METHYLATION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.DNA_METHYLATION;
        } else if (TrackType.OTHER.name().equalsIgnoreCase(type)) {
            trackType = TrackType.OTHER;
        } else if (TrackType.GENE_EXPRESSION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.GENE_EXPRESSION;
        } else if (TrackType.LOH.name().equalsIgnoreCase(type)) {
            trackType = TrackType.LOH;
        } else if (TrackType.MUTATION.name().equalsIgnoreCase(type)) {
            trackType = TrackType.MUTATION;
        } else if (TrackType.PHASTCON.name().equalsIgnoreCase(type)) {
            trackType = TrackType.PHASTCON;
        } else if (TrackType.TILING_ARRAY.name().equalsIgnoreCase(type)) {
            trackType = TrackType.TILING_ARRAY;
        }
        ColorScale colorScale = ColorScaleFactory.getScaleFromString(value);
        if (colorScale instanceof ContinuousColorScale) {
            session.setColorScale(trackType, (ContinuousColorScale)colorScale);
        }
    }

    private String getAttribute(Element element, String key) {
        String value = element.getAttribute(key);
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    static {
        attributeSynonymMap.put("DATA FILE", "DATA SET");
        attributeSynonymMap.put("TRACK NAME", "NAME");
    }

    public static enum SessionAttribute {
        BOOLEAN_OPERATOR("booleanOperator"),
        COLOR("color"),
        CHROMOSOME("chromosome"),
        END_INDEX("end"),
        EXPAND("expand"),
        FILTER_MATCH("match"),
        FILTER_SHOW_ALL_TRACKS("showTracks"),
        GENOME("genome"),
        GROUP_TRACKS_BY("groupTracksBy"),
        HEIGHT("height"),
        ID("id"),
        ITEM("item"),
        LOCUS("locus"),
        NAME("name"),
        SAMPLE_ID("sampleID"),
        RESOURCE_TYPE("resourceType"),
        OPERATOR("operator"),
        RELATIVE_PATH("relativePath"),
        RENDERER("renderer"),
        SCALE("scale"),
        START_INDEX("start"),
        VALUE("value"),
        VERSION("version"),
        VISIBLE("visible"),
        WINDOW_FUNCTION("windowFunction"),
        DISPLAY_NAME("displayName"),
        COLOR_SCALE("colorScale"),
        PATH("path"),
        LABEL("label"),
        SERVER_URL("serverURL"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        URL("url"),
        FEATURE_URL("featureURL"),
        DESCRIPTION("description"),
        TYPE("type"),
        COVERAGE("coverage"),
        TRACK_LINE("trackLine");

        private String name;

        private SessionAttribute(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static SessionAttribute findEnum(String value) {
            if (value == null) {
                return null;
            }
            return SessionAttribute.valueOf(value);
        }
    }

    public static enum SessionElement {
        PANEL("Panel"),
        TRACK("Track"),
        COLOR_SCALE("ColorScale"),
        COLOR_SCALES("ColorScales"),
        DATA_TRACK("DataTrack"),
        DATA_TRACKS("DataTracks"),
        FEATURE_TRACKS("FeatureTracks"),
        DATA_FILE("DataFile"),
        RESOURCE("Resource"),
        RESOURCES("Resources"),
        FILES("Files"),
        FILTER_ELEMENT("FilterElement"),
        FILTER("Filter"),
        SESSION("Session"),
        GLOBAL("Global"),
        REGION("Region"),
        REGIONS("Regions"),
        DATA_RANGE("DataRange"),
        PREFERENCES("Preferences"),
        PROPERTY("Property");

        private String name;

        private SessionElement(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static SessionElement findEnum(String value) {
            if (value == null) {
                return null;
            }
            return SessionElement.valueOf(value);
        }
    }
}

