/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.util.SeekableStream;
import org.broad.igv.util.SeekableStreamFactory;

public class SamQueryTextReader
implements AlignmentQueryReader {
    static Logger log = Logger.getLogger(SamQueryTextReader.class);
    String samFile;
    SeekableStream stream;
    FeatureIndex featureIndex;
    SAMFileHeader header;

    public SamQueryTextReader(String samFile) throws IOException {
        this(samFile, true);
    }

    public SamQueryTextReader(String samFile, boolean requireIndex) throws IOException {
        this.samFile = samFile;
        this.stream = SeekableStreamFactory.getStreamFor(samFile);
        this.loadHeader();
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(samFile);
            if (this.featureIndex == null) {
                throw new DataLoadException("Could not locate index file.", samFile);
            }
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    private void loadHeader() {
        SAMFileReader reader = new SAMFileReader(this.stream);
        this.header = reader.getFileHeader();
        reader.close();
    }

    @Override
    public synchronized CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        int startAdjustment = contained ? 0 : this.featureIndex.getLongestFeature(sequence);
        int startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
        FeatureIndex.TileDef seekPos = this.featureIndex.getTileDef(sequence, startTileNumber);
        if (seekPos != null) {
            try {
                this.stream.close();
                this.stream = SeekableStreamFactory.getStreamFor(this.samFile);
                this.stream.seek(seekPos.getStartPosition());
                SAMFileReader reader = new SAMFileReader(this.stream);
                reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
                SAMRecordIterator iter = reader.iterator();
                return new SAMQueryIterator(sequence, start, end, contained, iter);
            }
            catch (IOException ex) {
                log.error("Error opening sam file", ex);
            }
        }
        return EmptyAlignmentIterator.getInstance();
    }

    @Override
    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.getIndex();
        }
        return this.featureIndex != null;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        return this.featureIndex;
    }

    @Override
    public Set<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return idx.getIndexedChromosomes();
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        SAMFileReader reader = new SAMFileReader(this.stream);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMRecordIterator iter = reader.iterator();
        return new SAMQueryIterator(iter);
    }

    class SAMQueryIterator
    implements CloseableIterator<Alignment> {
        String chr;
        int start;
        int end;
        boolean contained;
        SAMRecord currentRecord;
        CloseableIterator<SAMRecord> wrappedIterator;

        public SAMQueryIterator(CloseableIterator<SAMRecord> wrappedIterator) {
            this.chr = null;
            this.wrappedIterator = wrappedIterator;
            this.currentRecord = (SAMRecord)wrappedIterator.next();
        }

        public SAMQueryIterator(String sequence, int start, int end, boolean contained, CloseableIterator<SAMRecord> wrappedIterator) {
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.wrappedIterator = wrappedIterator;
            this.advanceToFirstRecord();
        }

        private void advanceToFirstRecord() {
            while (this.wrappedIterator.hasNext()) {
                this.currentRecord = (SAMRecord)this.wrappedIterator.next();
                if (this.currentRecord.getReferenceName().equals(this.chr) && (!this.contained || this.currentRecord.getAlignmentStart() < this.start) && (this.contained || this.currentRecord.getAlignmentEnd() < this.start)) continue;
                break;
            }
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null && this.currentRecord != null) {
                return true;
            }
            if (this.currentRecord == null || this.chr != null && !this.chr.equals(this.currentRecord.getReferenceName())) {
                return false;
            }
            return this.contained ? this.currentRecord.getAlignmentEnd() <= this.end : this.currentRecord.getAlignmentStart() <= this.end;
        }

        @Override
        public SamAlignment next() {
            SAMRecord ret = this.currentRecord;
            this.currentRecord = this.wrappedIterator.hasNext() ? (SAMRecord)this.wrappedIterator.next() : null;
            return new SamAlignment(ret);
        }

        @Override
        public void remove() {
        }
    }
}

