/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.reader.AlignmentParser;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.DotAlignedParser;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.GeraldParser;
import org.broad.igv.sam.reader.PSLAlignmentParser;
import org.broad.igv.sam.reader.SamUtils;

public class GeraldQueryReader
implements AlignmentQueryReader {
    private static Logger log = Logger.getLogger(GeraldQueryReader.class);
    static int MAX_READ_LENGTH = 100;
    static int maxTileCount = 20;
    String alignmentFile;
    FeatureIndex featureIndex;
    FileInputStream is;
    AlignmentParser parser;

    public GeraldQueryReader(String alignmentFile) {
        this(alignmentFile, true);
    }

    public GeraldQueryReader(String alignmentFile, boolean requireIndex) {
        this.alignmentFile = alignmentFile;
        this.parser = GeraldQueryReader.getParserFor(alignmentFile);
        try {
            this.is = new FileInputStream(alignmentFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(alignmentFile);
            if (this.featureIndex == null) {
                throw new DataLoadException("Could not locate index file.", alignmentFile);
            }
        }
    }

    private static AlignmentParser getParserFor(String fn) {
        if (fn.endsWith(".aligned") || fn.endsWith(".aligned.txt")) {
            return new DotAlignedParser();
        }
        if (fn.endsWith(".bedz") || fn.endsWith(".bed")) {
            return new DotAlignedParser(true);
        }
        if (fn.endsWith(".psl") || fn.endsWith(".psxl")) {
            return new PSLAlignmentParser();
        }
        return new GeraldParser();
    }

    @Override
    public SAMFileHeader getHeader() {
        return null;
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.alignmentFile);
        }
        return this.featureIndex;
    }

    @Override
    public Set<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return idx.getIndexedChromosomes();
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.alignmentFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        int startAdjustment = contained ? 0 : this.featureIndex.getLongestFeature(sequence);
        return new GeraldQueryIterator(sequence, start - startAdjustment, end, contained);
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new GeraldQueryIterator();
    }

    class GeraldQueryIterator
    implements CloseableIterator<Alignment> {
        String chr;
        int start;
        int end;
        boolean contained;
        Alignment currentRecord;
        AsciiLineReader reader;

        public GeraldQueryIterator() {
            this.chr = null;
            this.reader = new AsciiLineReader(GeraldQueryReader.this.is);
            this.readNextRecord();
        }

        public GeraldQueryIterator(String sequence, int start, int end, boolean contained) {
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.seekToStart();
            this.reader = new AsciiLineReader(GeraldQueryReader.this.is);
            this.advanceToFirstRecord();
        }

        private Alignment readNextRecord() {
            this.currentRecord = GeraldQueryReader.this.parser.readNextRecord(this.reader);
            return this.currentRecord;
        }

        private void advanceToFirstRecord() {
            while (!(this.readNextRecord() == null || !this.currentRecord.getChr().equals(this.chr) || this.contained && this.currentRecord.getStart() >= this.start || !this.contained && this.currentRecord.getEnd() >= this.start)) {
            }
        }

        @Override
        public void close() {
            try {
                GeraldQueryReader.this.is.close();
            }
            catch (IOException ex) {
                log.error("Error closing alignment file", ex);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.chr == null) {
                return this.currentRecord != null;
            }
            if (this.currentRecord == null || !this.chr.equals(this.currentRecord.getChr())) {
                return false;
            }
            return this.contained ? this.currentRecord.getEnd() <= this.end : this.currentRecord.getStart() <= this.end;
        }

        @Override
        public Alignment next() {
            Alignment ret = this.currentRecord;
            this.readNextRecord();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void seekToStart() {
            if (GeraldQueryReader.this.featureIndex == null) {
                throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
            }
            int startAdjustment = this.contained ? 0 : MAX_READ_LENGTH;
            int startTileNumber = Math.max(0, this.start - startAdjustment) / GeraldQueryReader.this.featureIndex.getTileWidth();
            FeatureIndex.TileDef seekPos = GeraldQueryReader.this.featureIndex.getTileDef(this.chr, startTileNumber);
            long startPosition = seekPos == null ? 0L : seekPos.getStartPosition();
            try {
                GeraldQueryReader.this.is = new FileInputStream(GeraldQueryReader.this.alignmentFile);
                GeraldQueryReader.this.is.getChannel().position(startPosition);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

