/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.BasicFeatureRenderer;
import org.broad.igv.renderer.FeatureDensityRenderer;
import org.broad.igv.renderer.GeneTrackRenderer;
import org.broad.igv.renderer.GisticTrackRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.MutationRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.ScatterplotRenderer;

public class RendererFactory {
    static Class defaultRendererClass = BarChartRenderer.class;

    public static Class getRendererClass(String rendererTypeName) {
        Class rendererClass = null;
        String typeName = rendererTypeName.toUpperCase();
        if (typeName.equals(RendererType.BAR_CHART.name()) || typeName.equals("BAR")) {
            rendererClass = BarChartRenderer.class;
        } else if (typeName.equals(RendererType.BASIC_FEATURE.name())) {
            rendererClass = BasicFeatureRenderer.class;
        } else if (typeName.equals(RendererType.FEATURE_DENSITY.name())) {
            rendererClass = FeatureDensityRenderer.class;
        } else if (typeName.equals(RendererType.GENE_TRACK.name())) {
            rendererClass = GeneTrackRenderer.class;
        } else if (typeName.equals(RendererType.GISTIC_TRACK.name())) {
            rendererClass = GisticTrackRenderer.class;
        } else if (typeName.equals(RendererType.HEATMAP.name())) {
            rendererClass = HeatmapRenderer.class;
        } else if (typeName.equals(RendererType.MUTATION.name())) {
            rendererClass = MutationRenderer.class;
        } else if (typeName.equals(RendererType.SCATTER_PLOT.name()) || typeName.toUpperCase().equals("POINTS")) {
            rendererClass = ScatterplotRenderer.class;
        } else if (typeName.equals(RendererType.LINE_PLOT.name()) || typeName.toUpperCase().equals("LINE")) {
            rendererClass = LineplotRenderer.class;
        }
        return rendererClass;
    }

    public static RendererType getRenderType(Renderer renderer) {
        return RendererFactory.getRenderType(renderer.getClass());
    }

    public static RendererType getRenderType(Class rendererClass) {
        RendererType rendererType = null;
        if (rendererClass.equals(BarChartRenderer.class)) {
            rendererType = RendererType.BAR_CHART;
        } else if (rendererClass.equals(BasicFeatureRenderer.class)) {
            rendererType = RendererType.BASIC_FEATURE;
        } else if (rendererClass.equals(FeatureDensityRenderer.class)) {
            rendererType = RendererType.FEATURE_DENSITY;
        } else if (rendererClass.equals(GeneTrackRenderer.class)) {
            rendererType = RendererType.GENE_TRACK;
        } else if (rendererClass.equals(GisticTrackRenderer.class)) {
            rendererType = RendererType.GISTIC_TRACK;
        } else if (rendererClass.equals(HeatmapRenderer.class)) {
            rendererType = RendererType.HEATMAP;
        } else if (rendererClass.equals(MutationRenderer.class)) {
            rendererType = RendererType.MUTATION;
        } else if (rendererClass.equals(ScatterplotRenderer.class)) {
            rendererType = RendererType.SCATTER_PLOT;
        } else if (rendererClass.equals(LineplotRenderer.class)) {
            rendererType = RendererType.LINE_PLOT;
        }
        return rendererType;
    }

    public static enum RendererType {
        BAR_CHART,
        BASIC_FEATURE,
        FEATURE_DENSITY,
        GENE_TRACK,
        GISTIC_TRACK,
        HEATMAP,
        MUTATION,
        SCATTER_PLOT,
        LINE_PLOT;

    }
}

