/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public abstract class DataRenderer
implements Renderer {
    private static Logger log = Logger.getLogger(DataRenderer.class);
    private static Color defaultColor = new Color(0, 0, 150);
    protected static final int AXIS_AREA_WIDTH = 60;
    protected static Color axisLineColor = new Color(255, 180, 180);
    private boolean overlayMode;
    public static float confThreshold = 0.02f;

    @Override
    public void setOverlayMode(boolean mode) {
        this.overlayMode = mode;
    }

    public boolean getOverlayMode() {
        return this.overlayMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Track track, List<LocusScore> scores, RenderContext context, Rectangle arect) {
        if (scores != null) {
            List<LocusScore> list = scores;
            synchronized (list) {
                this.renderScores(track, scores, context, arect);
            }
        }
    }

    @Override
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
    }

    @Override
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
        PreferenceManager.ChartPreferences prefs = PreferenceManager.getInstance().getChartPreferences();
        if (context.getChr().equals("All")) {
            return;
        }
        if (prefs.isDrawAxis()) {
            Rectangle axisRect = new Rectangle(rect.x, rect.y + 1, 60, rect.height);
            Graphics2D whiteGraphics = context.getGraphic2DForColor(Color.white);
            whiteGraphics.fillRect(axisRect.x, axisRect.y, axisRect.width, axisRect.height);
            Graphics2D axisGraphics = context.getGraphic2DForColor(axisLineColor);
            axisGraphics.drawLine(rect.x + 60, rect.y, rect.x + 60, rect.y + rect.height);
        }
    }

    @Override
    public Color getDefaultColor() {
        return defaultColor;
    }

    protected abstract void renderScores(Track var1, List<LocusScore> var2, RenderContext var3, Rectangle var4);
}

