/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import org.broad.igv.renderer.AbstractColorScale;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.util.ColorUtilities;

public class ContinuousColorScale
extends AbstractColorScale {
    public static String serializedClassName = "ContinuousColorScale";
    private boolean useDoubleGradient;
    private double negEnd;
    private double posEnd;
    private double negStart;
    private double posStart;
    private Color minColor;
    private Color midColor;
    private Color maxColor;
    private Color[] colors;
    private Color noDataColor = UIConstants.NO_DATA_COLOR;
    private boolean defaultCS = false;
    private double delta;

    public ContinuousColorScale(String string) {
        String[] tokens = string.split(";");
        if (tokens.length == 5) {
            this.negEnd = Double.parseDouble(tokens[1]);
            this.posEnd = Double.parseDouble(tokens[2]);
            this.minColor = ColorUtilities.convertRGBStringToColor(tokens[3]);
            this.maxColor = ColorUtilities.convertRGBStringToColor(tokens[4]);
            this.useDoubleGradient = false;
        } else if (tokens.length == 8) {
            this.negStart = Double.parseDouble(tokens[1]);
            this.negEnd = Double.parseDouble(tokens[2]);
            this.posStart = Double.parseDouble(tokens[3]);
            this.posEnd = Double.parseDouble(tokens[4]);
            this.minColor = ColorUtilities.convertRGBStringToColor(tokens[5]);
            this.midColor = ColorUtilities.convertRGBStringToColor(tokens[6]);
            this.maxColor = ColorUtilities.convertRGBStringToColor(tokens[7]);
            this.useDoubleGradient = true;
        } else {
            throw new RuntimeException("Illegal ColorScale: " + string);
        }
        this.initColors();
    }

    public ContinuousColorScale(double min, double max, Color minColor, Color maxColor) {
        this.negEnd = min;
        this.posEnd = max;
        this.posStart = this.negStart = Math.max(0.0, min);
        this.midColor = Color.white;
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.useDoubleGradient = false;
        this.initColors();
    }

    public ContinuousColorScale(double min, double mid, double max, Color minColor, Color midColor, Color maxColor) {
        this.negEnd = min;
        this.posEnd = max;
        this.negStart = mid;
        this.posStart = mid;
        this.minColor = minColor;
        this.midColor = midColor;
        this.maxColor = maxColor;
        this.useDoubleGradient = true;
    }

    public ContinuousColorScale(double negStart, double negEnd, double posStart, double posEnd, Color minColor, Color midColor, Color maxColor) {
        this.negEnd = negEnd;
        this.posEnd = posEnd;
        this.negStart = negStart;
        this.posStart = posStart;
        this.minColor = minColor;
        this.midColor = midColor;
        this.maxColor = maxColor;
        this.useDoubleGradient = true;
    }

    public ContinuousColorScale(ContinuousColorScale otherScale) {
        this.negEnd = otherScale.negEnd;
        this.posEnd = otherScale.posEnd;
        this.negStart = otherScale.negStart;
        this.posStart = otherScale.posStart;
        this.minColor = otherScale.minColor;
        this.midColor = otherScale.midColor;
        this.maxColor = otherScale.maxColor;
        this.useDoubleGradient = true;
    }

    public void setDefault(boolean defaultCS) {
        this.defaultCS = defaultCS;
    }

    @Override
    public boolean isDefault() {
        return this.defaultCS;
    }

    public void setNegEnd(double negEnd) {
        this.negEnd = negEnd;
    }

    public void setPosEnd(double posEnd) {
        this.posEnd = posEnd;
        this.colors = null;
    }

    public void setNegStart(double negStart) {
        this.negStart = negStart;
        this.colors = null;
    }

    public void setPosStart(double posStart) {
        this.posStart = posStart;
        this.colors = null;
    }

    public void setMinColor(Color minColor) {
        this.minColor = minColor;
        this.colors = null;
    }

    public void setMidColor(Color midColor) {
        this.midColor = midColor;
        this.colors = null;
    }

    public void setMaxColor(Color maxColor) {
        this.maxColor = maxColor;
        this.colors = null;
    }

    @Override
    public String asString() {
        StringBuffer buf = new StringBuffer();
        buf.append(serializedClassName + ";");
        if (this.useDoubleGradient) {
            buf.append(String.valueOf(this.negStart) + ";");
            buf.append(String.valueOf(this.negEnd) + ";");
            buf.append(String.valueOf(this.posStart) + ";");
            buf.append(String.valueOf(this.posEnd) + ";");
            buf.append(ColorUtilities.convertColorToRGBString(this.minColor) + ";");
            buf.append(ColorUtilities.convertColorToRGBString(this.midColor) + ";");
            buf.append(ColorUtilities.convertColorToRGBString(this.maxColor));
        } else {
            buf.append(String.valueOf(this.negEnd) + ";");
            buf.append(String.valueOf(this.posEnd) + ";");
            buf.append(ColorUtilities.convertColorToRGBString(this.minColor) + ";");
            buf.append(ColorUtilities.convertColorToRGBString(this.maxColor));
        }
        return buf.toString();
    }

    private void initColors() {
        this.colors = new Color[251];
        this.delta = (this.posEnd - this.negEnd) / (double)this.colors.length;
        if (this.isUseDoubleGradient()) {
            ColorGradient csPos = new ColorGradient(this.posStart, this.posEnd, this.midColor, this.maxColor);
            ColorGradient csNeg = new ColorGradient(this.negEnd, this.negStart, this.minColor, this.midColor);
            for (int i2 = 0; i2 < this.colors.length; ++i2) {
                double x = this.getMinimum() + (double)i2 * this.delta;
                this.colors[i2] = x > this.negStart && x < this.posStart ? this.midColor : (x <= this.negStart ? csNeg.getColor(x) : csPos.getColor(x));
            }
        } else {
            ColorGradient cs = new ColorGradient(this.negEnd, this.posEnd, this.minColor, this.maxColor);
            for (int i3 = 0; i3 < this.colors.length; ++i3) {
                double x = this.getMinimum() + (double)i3 * this.delta;
                this.colors[i3] = cs.getColor(x);
            }
        }
    }

    @Override
    public Color getColor(float val) {
        if (this.colors == null) {
            this.initColors();
        }
        if ((double)val >= 1.0001 * this.negStart && (double)val <= 1.0001 * this.posStart) {
            return this.midColor;
        }
        int index = (int)Math.round(((double)val - this.negEnd) / this.delta);
        index = Math.max(0, Math.min(index, this.colors.length - 1));
        return this.colors[index];
    }

    public void setNoDataColor(Color color) {
        this.noDataColor = color;
    }

    @Override
    public Color getNoDataColor() {
        return this.noDataColor;
    }

    public double getNegStart() {
        return this.negStart;
    }

    public double getPosStart() {
        return this.posStart;
    }

    public double getMinimum() {
        return this.negEnd;
    }

    public double getMaximum() {
        return this.posEnd;
    }

    public double getBaseline() {
        return (this.negStart + this.posStart) / 2.0;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public Color getMidColor() {
        return this.midColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public boolean isUseDoubleGradient() {
        return this.useDoubleGradient;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ContinuousColorScale that = (ContinuousColorScale)o2;
        if (Double.compare(that.negEnd, this.negEnd) != 0) {
            return false;
        }
        if (Double.compare(that.negStart, this.negStart) != 0) {
            return false;
        }
        if (Double.compare(that.posEnd, this.posEnd) != 0) {
            return false;
        }
        if (Double.compare(that.posStart, this.posStart) != 0) {
            return false;
        }
        if (this.useDoubleGradient != that.useDoubleGradient) {
            return false;
        }
        if (!this.maxColor.equals(that.maxColor)) {
            return false;
        }
        if (!this.midColor.equals(that.midColor)) {
            return false;
        }
        if (!this.minColor.equals(that.minColor)) {
            return false;
        }
        return this.noDataColor.equals(that.noDataColor);
    }

    public int hashCode() {
        int result = this.useDoubleGradient ? 1 : 0;
        long temp = this.negEnd != 0.0 ? Double.doubleToLongBits(this.negEnd) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.posEnd != 0.0 ? Double.doubleToLongBits(this.posEnd) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.negStart != 0.0 ? Double.doubleToLongBits(this.negStart) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.posStart != 0.0 ? Double.doubleToLongBits(this.posStart) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.minColor.hashCode();
        result = 31 * result + this.midColor.hashCode();
        result = 31 * result + this.maxColor.hashCode();
        result = 31 * result + this.noDataColor.hashCode();
        return result;
    }

    static class ColorGradient {
        boolean useDoubleGradient = true;
        double min;
        double max;
        double mid;
        BufferedImage posImage;
        BufferedImage negImage;

        public ColorGradient(double min, double mid, double max, Color negColor, Color neutralColor, Color posColor) {
            this.useDoubleGradient = true;
            this.min = min;
            this.max = max;
            this.mid = mid;
            this.posImage = this.createGradientImage(neutralColor, posColor);
            this.negImage = this.createGradientImage(negColor, neutralColor);
        }

        public ColorGradient(double min, double max, Color neutralColor, Color posColor) {
            this.useDoubleGradient = false;
            this.min = min;
            this.max = max;
            this.posImage = this.createGradientImage(neutralColor, posColor);
        }

        private BufferedImage createGradientImage(Color color1, Color color2) {
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
            Graphics2D graphics = image.createGraphics();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 255.0f, 0.0f, color2);
            graphics.setPaint(gp);
            graphics.drawRect(0, 0, 255, 1);
            graphics.dispose();
            return image;
        }

        public Color getColor(double value) {
            int rgb;
            if (this.useDoubleGradient) {
                double maximum = value < this.mid ? this.min : this.max;
                int colorIndex = (int)(255.0 * (value - this.mid) / (maximum - this.mid));
                colorIndex = colorIndex > 255 ? 255 : colorIndex;
                rgb = value < this.mid ? this.negImage.getRGB(255 - colorIndex, 0) : this.posImage.getRGB(colorIndex, 0);
            } else {
                double span = this.max - this.min;
                int colorIndex = 0;
                colorIndex = value <= this.min ? 0 : (value >= this.max ? 255 : (int)((value - this.min) / span * 255.0));
                rgb = this.posImage.getRGB(colorIndex, 0);
            }
            return new Color(rgb);
        }
    }
}

