/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.main.CommandExecutor;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.WaitCursorManager;

public class CommandListener
implements Runnable {
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    boolean halt = false;

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
        }
    }

    public static synchronized void start() {
        listener = new CommandListener();
        Thread listenerThread = new Thread(listener);
        listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int port = PreferenceManager.getInstance().getPortNumber();
        CommandExecutor cmdExe = new CommandExecutor();
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            log.info("Listening on port " + port);
            while (!this.halt) {
                Socket clientSocket = null;
                try {
                    String inputLine;
                    clientSocket = serverSocket.accept();
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    while ((inputLine = in.readLine()) != null) {
                        Globals.batch = true;
                        Globals.setSuppress(true);
                        WaitCursorManager.CursorToken cursorToken = null;
                        try {
                            String cmd = inputLine;
                            if (this.halt) {
                                if (cmd.startsWith("GET")) {
                                    this.sendHTTPResponse(out, "ERROR IGV port is closed");
                                    break;
                                }
                                out.println("ERROR IGV port is closed");
                                break;
                            }
                            if (cmd.startsWith("GET")) {
                                String result = this.processGet(cmd, in, cmdExe);
                                this.sendHTTPResponse(out, result);
                                clientSocket.close();
                                clientSocket = serverSocket.accept();
                                out = new PrintWriter(clientSocket.getOutputStream(), true);
                                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                                continue;
                            }
                            out.println(cmdExe.execute(inputLine));
                        }
                        finally {
                            Globals.setSuppress(false);
                            Globals.batch = false;
                            if (cursorToken == null) continue;
                            WaitCursorManager.removeWaitCursor(cursorToken);
                        }
                    }
                    out.close();
                    in.close();
                    clientSocket.close();
                }
                catch (IOException e2) {
                    log.error("Accept failed.", e2);
                }
                finally {
                    clientSocket.close();
                    Globals.setSuppress(false);
                }
            }
        }
        catch (BindException e3) {
            log.error(e3);
        }
        catch (Exception e4) {
            log.error("Could not listen on port: " + port, e4);
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (IOException ex) {
                log.error("Error closing command listener socket", ex);
            }
        }
    }

    private void sendHTTPResponse(PrintWriter out, String result) {
        out.println("HTTP/1.0 204 OK");
        out.println(" Server: IGV");
        out.println("Connection: close");
        out.println();
        out.println(result);
        out.println();
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processGet(String line, BufferedReader reader, CommandExecutor cmdExe) throws IOException {
        String nextLine = URLDecoder.decode(line);
        String result = "OK";
        String[] tokens = nextLine.split(" ");
        if (tokens.length < 2) {
            return "ERROR unexpected command line: " + line;
        }
        String[] parts = tokens[1].split("\\?");
        if (parts.length < 2) {
            return "ERROR unexpected command line: " + line;
        }
        String command = parts[0];
        Map<String, String> params = this.parseParameters(parts[1]);
        IGVMainFrame mainFrame = IGVMainFrame.getInstance();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/load")) {
            if (!params.containsKey("file")) return "ERROR Parameter \"file\" is required";
            String genomeID = params.get("genome");
            String mergeValue = params.get("merge");
            String locus = params.get("locus");
            if (genomeID != null) {
                mainFrame.selectGenomeFromList(genomeID);
            }
            boolean merge = mergeValue == null ? true : mergeValue.equalsIgnoreCase("true");
            result = cmdExe.execute("hget " + params.get("file") + " " + locus + " " + merge);
        } else {
            if (!command.equals("/reload") && !command.equals("/goto")) return "ERROR Unknown command: " + command;
            String locus = params.get("locus");
            mainFrame.goToLocus(locus);
        }
        while (nextLine.length() > 0) {
            nextLine = reader.readLine();
        }
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=");
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            params.put(kv[0], kv[1]);
        }
        return params;
    }
}

