/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.UCSCParser;
import org.broad.igv.util.ResourceLocator;

public class PSLParser
extends UCSCParser {
    @Override
    public boolean isFeatureFile(ResourceLocator locator) {
        String path = locator.getPath();
        return path.endsWith(".psl") || path.endsWith(".psl.gz") || path.endsWith(".pslx") || path.endsWith(".pslx.gz");
    }

    @Override
    protected Feature parseLine(String[] tokens, int nTokens) {
        if (nTokens < 21) {
            return null;
        }
        int tSize = Integer.parseInt(tokens[14]);
        String chr = tokens[13];
        int start = Integer.parseInt(tokens[15]);
        String strandString = tokens[8];
        Strand strand = strandString.startsWith("+") ? Strand.POSITIVE : Strand.NEGATIVE;
        boolean gNeg = false;
        if (strandString.length() > 1) {
            gNeg = strandString.charAt(1) == '-';
        }
        BasicFeature f2 = new BasicFeature();
        f2.setName(tokens[9]);
        f2.setChr(chr);
        f2.setStart(start);
        f2.setEnd(Integer.parseInt(tokens[16]));
        f2.setStrand(strand);
        int exonCount = Integer.parseInt(tokens[17]);
        String[] exonSizes = tokens[18].split(",");
        String[] startsBuffer = tokens[20].split(",");
        if (startsBuffer.length == exonSizes.length && exonCount == startsBuffer.length) {
            for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                int exonSize = Integer.parseInt(exonSizes[i2]);
                int exonStart = Integer.parseInt(startsBuffer[i2]);
                if (gNeg) {
                    exonStart = tSize - exonStart - exonSize;
                }
                int exonEnd = exonStart + exonSize;
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                f2.addExon(exon);
            }
        }
        return f2;
    }
}

