/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.util.ColorTable;

public class Mutation
implements Feature {
    private static Logger log = Logger.getLogger(Mutation.class);
    private static Map<String, Color> colors;
    private String sampleId;
    private String chr;
    private int start;
    private int end;
    private String type;
    private Color color;
    private Map<String, String> attributes;
    private String valueString;

    public Mutation(String runId, String chromosome, int start, int end, String type) {
        this.sampleId = runId;
        this.chr = chromosome;
        this.start = start;
        this.end = end;
        this.type = type;
    }

    public Mutation(Mutation mutation) {
        this.sampleId = mutation.sampleId;
        this.chr = mutation.chr;
        this.start = mutation.start;
        this.end = mutation.end;
        this.type = mutation.type;
        this.color = mutation.color;
    }

    @Override
    public void setChr(String chr) {
        this.chr = chr;
    }

    @Override
    public void setName(String name) {
        this.type = name;
    }

    @Override
    public Mutation copy() {
        return new Mutation(this);
    }

    public String getSampleId() {
        return this.sampleId;
    }

    @Override
    public String getType() {
        return "mutation";
    }

    public String getMutationType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.type.toString();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        if (this.valueString == null && this.attributes != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html>Type: ");
            buf.append(this.type + "<br>");
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                buf.append(entry.getKey() + ": " + entry.getValue() + "<br>");
            }
            this.valueString = buf.toString();
        }
        return this.valueString;
    }

    @Override
    public boolean hasScore() {
        return false;
    }

    @Override
    public Strand getStrand() {
        return Strand.NONE;
    }

    @Override
    public boolean hasStrand() {
        return false;
    }

    public boolean overlaps(Feature track) {
        return false;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    public void setColor(Color color) {
    }

    @Override
    public Color getColor() {
        ColorTable colorTable = PreferenceManager.getInstance().getMutationColorScheme();
        Color c2 = colorTable.get(this.getMutationType());
        return c2;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    public int[] getStarts() {
        return null;
    }

    public int[] getEnds() {
        return null;
    }

    @Override
    public float getScore() {
        return 0.0f;
    }

    @Override
    public float getConfidence() {
        return 1.0f;
    }

    public int getLevel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Feature feature) {
        if (feature == null || !this.getChr().equals(feature.getChr())) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.end;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public void setConfidence(float confidence) {
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public String getIdentifier() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AminoAcidSequence getAminoAcidSequence(int exonIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getCdEnd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getCdStart() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, String> getAttributes() {
        return null;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

