/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.LocusScore;

public class FeatureUtils {
    public static Map<String, List<Feature>> divideByChromosome(List<Feature> features) {
        LinkedHashMap<String, List<Feature>> featureMap = new LinkedHashMap<String, List<Feature>>();
        for (Feature f2 : features) {
            ArrayList<Feature> flist = (ArrayList<Feature>)featureMap.get(f2.getChr());
            if (flist == null) {
                flist = new ArrayList<Feature>();
                featureMap.put(f2.getChr(), flist);
            }
            flist.add(f2);
        }
        return featureMap;
    }

    public static List<List<Feature>> segreateFeatures(List<Feature> features, double scale) {
        ArrayList<List<Feature>> segmentedLists = new ArrayList<List<Feature>>();
        LinkedList<Feature> workingList = new LinkedList<Feature>(features);
        FeatureUtils.sortFeatureList(workingList);
        while (workingList.size() > 0) {
            LinkedList<Feature> nonOverlappingFeatures = new LinkedList<Feature>();
            LinkedList<Feature> overlappingFeatures = new LinkedList<Feature>();
            Feature f1 = (Feature)workingList.remove(0);
            nonOverlappingFeatures.add(f1);
            while (workingList.size() > 0) {
                int scaledEnd;
                Feature f2 = (Feature)workingList.remove(0);
                int scaledStart = (int)((double)f2.getStart() / scale);
                if (scaledStart > (scaledEnd = (int)((double)f1.getEnd() / scale))) {
                    nonOverlappingFeatures.add(f2);
                    f1 = f2;
                    continue;
                }
                overlappingFeatures.add(f2);
            }
            segmentedLists.add(nonOverlappingFeatures);
            workingList = overlappingFeatures;
        }
        return segmentedLists;
    }

    public static void sortFeatureList(List<? extends LocusScore> features) {
        Collections.sort(features, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocusScore f1 = (LocusScore)o1;
                LocusScore f2 = (LocusScore)o2;
                return f1.getStart() - f2.getStart();
            }
        });
    }

    public static LocusScore getFeatureAt(double position, double minWidth, List<? extends LocusScore> features) {
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            int idx = (startIdx + endIdx) / 2;
            LocusScore feature = features.get(idx);
            double effectiveStart = feature.getStart() + 1;
            if (position >= effectiveStart) {
                double effectiveWidth = Math.max(minWidth, (double)(feature.getEnd() - feature.getStart()));
                if (position <= effectiveStart + effectiveWidth) {
                    return features.get(idx);
                }
                if (idx == startIdx) {
                    return null;
                }
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return null;
    }

    public static LocusScore getFeatureAfter(double position, List<? extends LocusScore> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        for (idx = startIdx; idx < features.size(); ++idx) {
            if (!((double)features.get(idx).getStart() > position)) continue;
            return features.get(idx);
        }
        return null;
    }

    public static LocusScore getFeatureBefore(double position, List<? extends LocusScore> features) {
        for (int index = FeatureUtils.getIndexBefore(position, features); index >= 0; --index) {
            LocusScore f2 = features.get(index);
            if (!((double)f2.getStart() < position)) continue;
            return f2;
        }
        return null;
    }

    public static int getIndexBefore(double position, List<? extends LocusScore> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return -1;
        }
        if ((double)features.get(0).getStart() >= position) {
            return 0;
        }
        int startIdx = 0;
        int endIdx = features.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)features.get(endIdx).getStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)features.get(idx).getStart() < position)) continue;
                return idx;
            }
        } else {
            for (idx = endIdx + 1; idx < features.size(); ++idx) {
                if (!((double)features.get(idx).getStart() >= position)) continue;
                return idx - 1;
            }
        }
        return -1;
    }
}

