/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.feature.Strand;

public class AminoAcidManager {
    static String filename = "codonTable.txt";
    static Map<String, AminoAcid> codonTable;

    public static AminoAcidSequence getAminoAcidSequence(String genomeId, String chr, int startPosition, int endPosition, Strand strand) {
        byte[] seqBytes = SequenceManager.readSequence(genomeId, chr, startPosition, endPosition);
        if (seqBytes == null) {
            return null;
        }
        String nucSequence = new String(seqBytes);
        List<AminoAcid> acids = AminoAcidManager.getAminoAcids(nucSequence, strand);
        int aminoStart = startPosition;
        return new AminoAcidSequence(strand, aminoStart, acids);
    }

    public static List<AminoAcid> getAminoAcids(String sequence, Strand direction) {
        if (codonTable == null) {
            AminoAcidManager.initTable();
        }
        int readLength = sequence.length() / 3;
        ArrayList<AminoAcid> acids = new ArrayList<AminoAcid>(readLength);
        for (int i2 = 0; i2 <= sequence.length() - 3; i2 += 3) {
            String codon = sequence.substring(i2, i2 + 3);
            if (direction == Strand.NEGATIVE) {
                codon = AminoAcidManager.getNucleotideComplement(codon);
            }
            if (codonTable == null || codon == null) {
                acids.add(AminoAcid.NULL_AMINO_ACID);
                continue;
            }
            AminoAcid aa = codonTable.get(codon);
            if (aa == null) {
                aa = AminoAcid.NULL_AMINO_ACID;
            }
            acids.add(codonTable.get(codon));
        }
        return acids;
    }

    private static String getNucleotideComplement(String sequence) {
        char[] complement = new char[sequence.length()];
        block6: for (int i2 = 0; i2 < sequence.length(); ++i2) {
            int j2 = sequence.length() - i2 - 1;
            char c2 = sequence.charAt(i2);
            switch (c2) {
                case 'T': {
                    complement[j2] = 65;
                    continue block6;
                }
                case 'A': {
                    complement[j2] = 84;
                    continue block6;
                }
                case 'C': {
                    complement[j2] = 71;
                    continue block6;
                }
                case 'G': {
                    complement[j2] = 67;
                    continue block6;
                }
                default: {
                    complement[j2] = c2;
                }
            }
        }
        return new String(complement);
    }

    static synchronized void initTable() {
        if (codonTable == null) {
            try {
                InputStream is = AminoAcidManager.class.getResourceAsStream("/resources/" + filename);
                if (is == null) {
                    return;
                }
                codonTable = new HashMap<String, AminoAcid>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    if (tokens.length != 4) continue;
                    String codon = tokens[0].trim().toUpperCase();
                    String fullName = tokens[1].trim();
                    String shortName = tokens[2].trim();
                    char symbol = tokens[3].trim().charAt(0);
                    codonTable.put(codon, new AminoAcid(fullName, shortName, symbol));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(AminoAcidManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

