/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Strand;

public abstract class AbstractFeature
implements Feature,
org.broad.tribble.Feature {
    private static Logger log = Logger.getLogger(AbstractFeature.class);
    private Strand strand = Strand.NONE;
    private String chromosome;
    private int start = -1;
    private int end = -1;
    private String type = "";
    protected Color color;
    protected String description;
    private Map<String, String> attributes;
    private String name = "";

    public AbstractFeature() {
    }

    public AbstractFeature(String chr, int start, int end, Strand strand) {
        this.chromosome = chr;
        this.start = start;
        this.end = end;
        this.strand = strand;
    }

    @Override
    public String getIdentifier() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasScore() {
        return false;
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public float getScore() {
        return Float.NaN;
    }

    @Override
    public void setConfidence(float confidence) {
    }

    @Override
    public float getConfidence() {
        return 1.0f;
    }

    @Override
    public String getChr() {
        return this.chromosome;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public boolean contains(Feature feature) {
        if (feature == null) {
            return false;
        }
        if (!this.getChr().equals(feature.getChr()) || this.getStrand() != feature.getStrand()) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    @Override
    public boolean hasStrand() {
        return this.strand != null && this.strand != Strand.NONE;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String[] rgb, int nTokens) {
        try {
            if (rgb[0].equals(".")) {
                return;
            }
            this.color = nTokens < 3 ? new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[0]), Integer.parseInt(rgb[0])) : new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setChr(String chromosome) {
        this.chromosome = chromosome;
    }
}

