/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.seg.Segment;
import org.broad.igv.data.seg.SegmentedBinaryLocalReader;
import org.broad.igv.data.seg.SegmentedBinaryReader;
import org.broad.igv.data.seg.SegmentedBinaryRemoteReader;
import org.broad.igv.data.seg.SegmentedChromosomeData;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;

public class SegmentedBinaryDataSet
implements SegmentedDataSet {
    SegmentedBinaryReader reader;
    private long lastRefreshTime = 0L;
    Boolean logNormalized = null;
    private List<String> sampleNames = null;
    Map<String, Map<String, List<LocusScore>>> segmentsCache = new HashMap<String, Map<String, List<LocusScore>>>();
    Map<String, SegmentedChromosomeData> chrData = new HashMap<String, SegmentedChromosomeData>();
    TrackType type = TrackType.COPY_NUMBER;

    public SegmentedBinaryDataSet(ResourceLocator locator) {
        this.reader = locator.getServerURL() == null ? new SegmentedBinaryLocalReader(locator.getPath()) : new SegmentedBinaryRemoteReader(locator);
        try {
            this.type = TrackType.valueOf(this.reader.getStringAttribute("type"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            String logNormalizedString = this.reader.getStringAttribute("logNormalized");
            if (logNormalizedString != null) {
                this.logNormalized = logNormalizedString.equals("true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!ViewContext.getInstance().getChrName().equals("All")) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<String, SegmentedChromosomeData> map = SegmentedBinaryDataSet.this.chrData;
                    synchronized (map) {
                        SegmentedChromosomeData cd = SegmentedBinaryDataSet.this.reader.getChromosomeData("All");
                        SegmentedBinaryDataSet.this.chrData.put("All", cd);
                    }
                }
            }).start();
        }
    }

    @Override
    public synchronized void refreshData(long timestamp) {
        if (timestamp > this.lastRefreshTime) {
            this.logNormalized = false;
            this.segmentsCache = new HashMap<String, Map<String, List<LocusScore>>>();
            this.lastRefreshTime = timestamp;
        }
    }

    @Override
    public List<LocusScore> getSegments(String heading, String chr) {
        List<LocusScore> segments;
        Map<String, List<LocusScore>> chrSegments = this.segmentsCache.get(heading);
        if (chrSegments == null) {
            chrSegments = new HashMap<String, List<LocusScore>>();
            this.segmentsCache.put(heading, chrSegments);
        }
        if ((segments = chrSegments.get(chr)) == null) {
            int i2;
            SegmentedChromosomeData cd = this.chrData.get(chr);
            if (cd == null) {
                cd = this.reader.getChromosomeData(chr);
                this.chrData.put(chr, cd);
            }
            int[] startLocations = cd.getStartLocations(heading);
            int[] endLocations = cd.getEndLocations(heading);
            float[] values = cd.getValues(heading);
            if (startLocations == null || startLocations.length == 0) {
                return null;
            }
            if (this.logNormalized == null) {
                this.logNormalized = false;
                for (i2 = 0; i2 < values.length; ++i2) {
                    if (!(values[i2] < 0.0f)) continue;
                    this.logNormalized = true;
                    break;
                }
            }
            assert (startLocations.length == endLocations.length);
            assert (endLocations.length == values.length);
            segments = new ArrayList<LocusScore>(startLocations.length);
            for (i2 = 0; i2 < startLocations.length; ++i2) {
                segments.add(new Segment(startLocations[i2], endLocations[i2], values[i2]));
                chrSegments.put(chr, segments);
            }
        }
        return segments;
    }

    @Override
    public List<String> getSampleNames() {
        if (this.sampleNames == null) {
            this.sampleNames = this.reader.getSampleNames();
        }
        return this.sampleNames;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    @Override
    public boolean isLogNormalized() {
        return this.logNormalized == null ? true : this.logNormalized;
    }

    @Override
    public double getDataMax(String chr) {
        return 3.0;
    }

    @Override
    public double getDataMin(String chr) {
        return -3.0;
    }

    @Override
    public synchronized List<LocusScore> getWholeGenomeScores(String heading) {
        return this.getSegments(heading, "All");
    }

    public static class ChromosomeChunk {
    }
}

