/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegFileParser;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class SegmentFileParser
implements SegFileParser {
    private static Logger log = Logger.getLogger(SegmentFileParser.class);
    boolean birdsuite = false;
    int sampleColumn = 0;
    int chrColumn = 1;
    int startColumn = 2;
    int endColumn = 3;
    int snpCountColumn = 4;
    int dataColumn = 5;
    ResourceLocator locator;

    public SegmentFileParser(ResourceLocator locator) {
        this.locator = locator;
        if (locator.getPath().toLowerCase().endsWith("birdseye_canary_calls")) {
            this.birdsuite = true;
        }
    }

    @Override
    public void loadSegments(SegmentedAsciiDataSet dataset) {
        if (this.birdsuite) {
            dataset.setTrackType(TrackType.CNV);
        }
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.locator);
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                if (nextLine.length() > 0) {
                    this.parseComment(nextLine, dataset);
                }
                nextLine = reader.readLine();
            }
            String[] headings = nextLine.split("\t");
            if (this.birdsuite) {
                this.sampleColumn = 0;
                this.chrColumn = 3;
                this.startColumn = 4;
                this.endColumn = 5;
                this.snpCountColumn = 6;
                this.dataColumn = 2;
            } else {
                this.dataColumn = headings.length - 1;
                this.snpCountColumn = this.dataColumn - 1;
                if (this.snpCountColumn < 4) {
                    this.snpCountColumn = -1;
                }
            }
            String[] tokens = new String[headings.length];
            Genome genome = ViewContext.getInstance().getGenome();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                int end;
                int start;
                int nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                if (nTokens <= 4) continue;
                try {
                    start = Integer.parseInt(tokens[this.startColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.startColumn + 1) + " must contain a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                try {
                    end = Integer.parseInt(tokens[this.endColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.endColumn + 1) + " must contain a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                String chr = tokens[this.chrColumn].trim();
                if (genome != null) {
                    chr = genome.getChromosomeAlias(chr);
                }
                String trackId = new String(tokens[this.sampleColumn].trim());
                int snpCount = 0;
                if (this.snpCountColumn > 0) {
                    try {
                        snpCount = Integer.parseInt(tokens[this.snpCountColumn]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    float value = Float.parseFloat(tokens[this.dataColumn]);
                    dataset.addSegment(trackId, chr, start, end, value, snpCount);
                }
                catch (NumberFormatException numberFormatException) {
                    log.info("Skipping line: " + nextLine);
                }
            }
        }
        catch (DataLoadException pe) {
            throw pe;
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Exception e2) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e2.getMessage(), (Throwable)e2, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e2);
        }
        finally {
            if (reader == null) {
                reader.close();
            }
        }
    }

    private void parseComment(String comment, SegmentedAsciiDataSet dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("type")) {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            try {
                dataset.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
            }
            catch (Exception exception) {}
        } else if (tmp.startsWith("track")) {
            TrackProperties props = new TrackProperties();
            ParsingUtils.parseTrackLine(comment, props);
            dataset.setTrackProperties(props);
        }
    }

    static enum Type {
        SEG,
        BIRDSUITE,
        NEXUS;

    }
}

