/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.data.rnai.RNAIHairpinCache;
import org.broad.igv.data.rnai.RNAIHairpinValue;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

public class RNAIGeneScore
implements LocusScore {
    String batchCondition;
    Feature gene;
    float geneScore;
    int geneConfidence;
    boolean hasGeneConfidence;
    int numberOfHairpins;
    int start;
    int end;
    List<RNAIHairpinValue> hairpinScores = null;

    public RNAIGeneScore(String batchId, Feature gene, float geneScore, int numberOfHairpins) {
        this.batchCondition = batchId;
        this.gene = gene;
        this.geneScore = geneScore;
        this.geneConfidence = 3;
        this.hasGeneConfidence = false;
        this.numberOfHairpins = numberOfHairpins;
        this.start = gene.getStart();
        this.end = gene.getEnd();
    }

    public RNAIGeneScore(String batchId, Feature gene, float geneScore, int confidence, int numberOfHairpins) {
        this.batchCondition = batchId;
        this.gene = gene;
        this.geneScore = geneScore;
        this.geneConfidence = confidence;
        this.hasGeneConfidence = true;
        this.numberOfHairpins = numberOfHairpins;
        this.start = gene.getStart();
        this.end = gene.getEnd();
    }

    public RNAIGeneScore(RNAIGeneScore score) {
        this.batchCondition = score.batchCondition;
        this.gene = score.gene;
        this.geneScore = score.geneScore;
        this.geneConfidence = score.geneConfidence;
        this.numberOfHairpins = score.numberOfHairpins;
        this.start = score.getStart();
        this.end = score.getEnd();
    }

    @Override
    public RNAIGeneScore copy() {
        return new RNAIGeneScore(this);
    }

    public boolean hasGeneConfidence() {
        return this.hasGeneConfidence;
    }

    public Feature getGene() {
        return this.gene;
    }

    public String getChr() {
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public float getScore() {
        return this.geneScore;
    }

    @Override
    public float getConfidence() {
        return this.geneConfidence;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public void setConfidence(float confidence) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<RNAIHairpinValue> getHairpinValues() {
        Collection<RNAIHairpinValue> tmp;
        if (this.hairpinScores == null && (tmp = RNAIHairpinCache.getInstance().getHairpinScores(this.batchCondition, this.gene.getName().toUpperCase())) != null) {
            this.hairpinScores = new ArrayList<RNAIHairpinValue>(tmp);
        }
        return this.hairpinScores;
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        Collection<RNAIHairpinValue> hpins;
        StringBuffer buf = new StringBuffer(100);
        buf.append("<b>Gene: " + this.gene.getName() + "</b><br>");
        buf.append("<b>Intensity: " + this.geneScore + "<br></b>");
        if (this.hasGeneConfidence) {
            buf.append("Confidence: " + this.geneConfidence + "<br>");
        }
        if ((hpins = this.getHairpinValues()) == null || hpins.isEmpty()) {
            buf.append("# Hairpins: " + this.numberOfHairpins + "<br>");
        } else {
            buf.append("Hairpin scores:<br>");
            for (RNAIHairpinValue hpScore : hpins) {
                if (hpScore.hasScoreSTD()) {
                    buf.append(hpScore.getName() + ": " + hpScore.getScoreMean() + "  (" + hpScore.getScoreSTD() + ")<br>");
                    continue;
                }
                buf.append(hpScore.getName() + ": " + hpScore.getScoreMean() + "<br>");
            }
        }
        return buf.toString();
    }
}

