/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class WiggleParser {
    private static Logger log = Logger.getLogger(WiggleParser.class);
    WiggleDataset dataset;
    private Type type = Type.BED;
    private String chr;
    String lastChr = "";
    int lastPosition = 0;
    private int start;
    private int step;
    private int windowSpan = 1;
    private int startBase = 1;
    IntArrayList startLocations = null;
    IntArrayList endLocations = null;
    FloatArrayList data = null;
    ResourceLocator resourceLocator;
    Set<String> unsortedChromosomes;
    int estArraySize;
    Map<String, Integer> longestFeatureMap = new HashMap<String, Integer>();

    public WiggleParser(ResourceLocator locator, String genomeId) {
        this.resourceLocator = locator;
        this.estArraySize = this.estArraySize(locator, genomeId);
        this.dataset = new WiggleDataset(genomeId, locator.getTrackName());
    }

    private int estArraySize(ResourceLocator locator, String genomeId) {
        int estLines = 100000;
        if (locator.getServerURL() == null) {
            estLines = ParsingUtils.estimateLineCount(locator.getPath());
        }
        int nChromosomes = GenomeManager.getInstance().getGenome(genomeId).getChromosomeNames().size();
        return Math.max(1000, estLines / nChromosomes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWiggle(ResourceLocator file) {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            int lineNo = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("track") && nextLine.contains("wiggle_0")) {
                    boolean bl = true;
                    return bl;
                }
                if (lineNo++ <= 100) continue;
                break;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return false;
    }

    public WiggleDataset parse() {
        String[] tokens = new String[10];
        this.lastPosition = -1;
        this.unsortedChromosomes = new HashSet<String>();
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.resourceLocator);
            int position = -1;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("#") || nextLine.startsWith("data") || nextLine.startsWith("browser")) continue;
                if (nextLine.startsWith("track")) {
                    this.type = Type.BED;
                    ParsingUtils.parseTrackLine(nextLine, this.dataset.getTrackProperties());
                    if (this.dataset.getTrackProperties().getBaseCoord() != TrackProperties.BaseCoord.ZERO) continue;
                    this.startBase = 0;
                    continue;
                }
                if (nextLine.startsWith("fixedStep")) {
                    this.type = Type.FIXED;
                    this.parseStepLine(nextLine);
                    position = this.start;
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                if (nextLine.startsWith("variableStep")) {
                    this.type = Type.VARIABLE;
                    this.parseStepLine(nextLine);
                    if (this.start >= this.lastPosition) continue;
                    this.unsortedChromosomes.add(this.chr);
                    continue;
                }
                int nTokens = ParsingUtils.splitWhitespace(nextLine, tokens);
                if (nTokens == 0) continue;
                try {
                    int startPosition;
                    if (this.type.equals((Object)Type.BED)) {
                        if (nTokens <= 3) continue;
                        this.chr = tokens[0].trim();
                        if (!this.chr.equals(this.lastChr)) {
                            this.changedChromosome(this.dataset, this.lastChr);
                        }
                        this.lastChr = this.chr;
                        startPosition = -1;
                        try {
                            startPosition = Integer.parseInt(tokens[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column 2  is not a number");
                            throw new ParserException("Column 2 must be numeric. Found: " + tokens[1], reader.getCurrentLineNumber(), nextLine);
                        }
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        this.startLocations.add(startPosition);
                        try {
                            int endPosition = Integer.parseInt(tokens[2].trim());
                            this.endLocations.add(endPosition);
                            int length = endPosition - startPosition;
                            this.updateLongestFeature(length);
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.error("Column 3  is not a number");
                            throw new ParserException("Column 3 must be numeric. Found: " + tokens[2], reader.getCurrentLineNumber(), nextLine);
                        }
                        this.data.add(Float.parseFloat(tokens[3].trim()));
                        continue;
                    }
                    if (this.type.equals((Object)Type.VARIABLE)) {
                        if (nTokens <= 1) continue;
                        startPosition = Integer.parseInt(tokens[0]) - 1;
                        if (startPosition < this.lastPosition) {
                            this.unsortedChromosomes.add(this.chr);
                        }
                        this.lastPosition = startPosition;
                        int end = startPosition + this.windowSpan;
                        this.startLocations.add(startPosition);
                        this.endLocations.add(end);
                        this.data.add(Float.parseFloat(tokens[1]));
                        continue;
                    }
                    if (position >= 0) {
                        this.startLocations.add(position);
                        this.endLocations.add(position + this.windowSpan);
                        this.data.add(Float.parseFloat(tokens[0]));
                    }
                    this.lastPosition = position += this.step;
                }
                catch (NumberFormatException e2) {
                    log.error(e2);
                    throw new ParserException(e2.getMessage(), reader.getCurrentLineNumber(), nextLine);
                }
            }
            this.changedChromosome(this.dataset, this.lastChr);
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Exception e3) {
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e3.getMessage(), (Throwable)e3, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e3);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.dataset.sort(this.unsortedChromosomes);
        this.dataset.setLongestFeatureMap(this.longestFeatureMap);
        return this.dataset;
    }

    private void updateLongestFeature(int length) {
        if (this.longestFeatureMap.containsKey(this.chr)) {
            this.longestFeatureMap.put(this.chr, Math.max(this.longestFeatureMap.get(this.chr), length));
        } else {
            this.longestFeatureMap.put(this.chr, length);
        }
    }

    private void parseStepLine(String header) {
        String[] tokens;
        for (String token : tokens = header.split("\\s+")) {
            String[] keyValue = token.split("=");
            if (keyValue.length < 2) continue;
            if (keyValue[0].equalsIgnoreCase("chrom")) {
                this.chr = keyValue[1];
                if (!this.chr.equals(this.lastChr)) {
                    this.changedChromosome(this.dataset, this.lastChr);
                }
                this.lastChr = this.chr;
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("start")) {
                this.start = Integer.parseInt(keyValue[1]) - this.startBase;
                if (this.start >= this.lastPosition) continue;
                this.unsortedChromosomes.add(this.chr);
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("step")) {
                this.step = Integer.parseInt(keyValue[1]);
                continue;
            }
            if (!keyValue[0].equalsIgnoreCase("span")) continue;
            this.windowSpan = Integer.parseInt(keyValue[1]);
            this.updateLongestFeature(this.windowSpan);
        }
    }

    private void changedChromosome(WiggleDataset dataset, String lastChr) {
        Genome genome = ViewContext.getInstance().getGenome();
        if (this.startLocations != null && this.startLocations.size() > 0) {
            String convertedChr = genome.getChromosomeAlias(lastChr);
            dataset.addDataChunk(convertedChr, this.startLocations, this.endLocations, this.data);
        }
        this.startLocations = new IntArrayList(this.estArraySize);
        this.endLocations = new IntArrayList(this.estArraySize);
        this.data = new FloatArrayList(this.estArraySize);
        this.lastPosition = -1;
    }

    private static enum Type {
        FIXED,
        VARIABLE,
        BED;

    }
}

