/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.track.TrackType;

public class DatasetDataSource
extends AbstractDataSource {
    private Logger log = Logger.getLogger(DatasetDataSource.class);
    String trackId;
    Dataset dataset;
    GenomeSummaryData genomeSummaryData;

    public DatasetDataSource(Genome genome, String trackId, Dataset dataset) {
        this.trackId = trackId;
        this.dataset = dataset;
        if (genome.getHomeChromosome().equals("All")) {
            if (dataset instanceof IGVDataset) {
                this.genomeSummaryData = ((IGVDataset)dataset).getGenomeSummary();
            } else {
                this.genomeSummaryData = new GenomeSummaryData(genome, new String[]{trackId});
                for (Chromosome chr : genome.getChromosomes()) {
                    int[] startLocations = dataset.getStartLocations(chr.getName());
                    if (chr.getName().equals("All") || startLocations == null || startLocations.length <= 0) continue;
                    HashMap<String, float[]> dMap = new HashMap<String, float[]>();
                    dMap.put(trackId, dataset.getData(trackId, chr.getName()));
                    this.genomeSummaryData.addData(chr.getName(), startLocations, dMap);
                }
            }
        }
    }

    @Override
    protected int getNumZoomLevels(String chr) {
        return 0;
    }

    @Override
    protected DataTile getRawData(String chr, int startLocation, int endLocation) {
        int[] startLocs = null;
        int[] endLocs = null;
        float[] data = null;
        String[] features = null;
        if (chr.equals("All") && this.genomeSummaryData != null) {
            endLocs = startLocs = this.genomeSummaryData.getLocations();
            data = this.genomeSummaryData.getData(this.trackId);
        } else {
            startLocs = this.dataset.getStartLocations(chr);
            endLocs = this.dataset.getEndLocations(chr);
            data = this.dataset.getData(this.trackId, chr);
            features = this.dataset.getFeatureNames(chr);
        }
        if (startLocs == null) {
            return null;
        }
        assert (startLocs.length == endLocs.length);
        assert (startLocs.length == data.length);
        int maxIndex = startLocs.length - 1;
        int startIdx = 0;
        int endIdx = maxIndex;
        int[] tmpStart = startLocs;
        int[] tmpEnd = endLocs;
        float[] tmpData = data;
        String[] tmpFeatures = features;
        int nPts = endIdx - startIdx + 1;
        if (tmpStart == null || tmpData == null || nPts <= 0) {
            return null;
        }
        startLocs = new int[nPts];
        endLocs = tmpEnd == null ? null : new int[nPts];
        data = new float[nPts];
        features = tmpFeatures == null ? null : new String[nPts];
        try {
            System.arraycopy(tmpStart, startIdx, startLocs, 0, nPts);
            System.arraycopy(tmpData, startIdx, data, 0, nPts);
            if (endLocs != null) {
                System.arraycopy(tmpEnd, startIdx, endLocs, 0, nPts);
            }
            if (features != null) {
                System.arraycopy(tmpFeatures, startIdx, features, 0, nPts);
            }
        }
        catch (Exception exception) {
            this.log.error("Exception getting raw data tile", exception);
            return null;
        }
        return new DataTile(startLocs, endLocs, data, features);
    }

    @Override
    public TrackType getTrackType() {
        try {
            return this.dataset.getType();
        }
        catch (Exception exception) {
            return TrackType.OTHER;
        }
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataset.isLogNormalized();
    }

    @Override
    public double getDataMax() {
        return this.dataset.getDataMax();
    }

    @Override
    public double getDataMin() {
        return this.dataset.getDataMin();
    }

    @Override
    public int getLongestFeature(String chr) {
        return this.dataset.getLongestFeature(chr);
    }
}

