/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.i18n.LocaleGroup;
import org.apache.batik.i18n.Localizable;

public class LocalizableSupport
implements Localizable {
    protected LocaleGroup localeGroup = LocaleGroup.DEFAULT;
    protected String bundleName;
    protected ClassLoader classLoader;
    protected Locale locale;
    protected Locale usedLocale;
    List resourceBundles = new ArrayList();
    Class lastResourceClass;
    Class cls;
    static /* synthetic */ Class class$java$lang$Object;

    public LocalizableSupport(String s, Class cls) {
        this(s, cls, null);
    }

    public LocalizableSupport(String s, Class cls, ClassLoader cl) {
        this.bundleName = s;
        this.cls = cls;
        this.classLoader = cl;
    }

    public LocalizableSupport(String s) {
        this(s, (ClassLoader)null);
    }

    public LocalizableSupport(String s, ClassLoader cl) {
        this.bundleName = s;
        this.classLoader = cl;
    }

    public void setLocale(Locale l) {
        if (this.locale != l) {
            this.locale = l;
            this.resourceBundles.clear();
            this.lastResourceClass = null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocaleGroup(LocaleGroup lg) {
        this.localeGroup = lg;
    }

    public LocaleGroup getLocaleGroup() {
        return this.localeGroup;
    }

    public void setDefaultLocale(Locale l) {
        this.localeGroup.setLocale(l);
    }

    public Locale getDefaultLocale() {
        return this.localeGroup.getLocale();
    }

    public String formatMessage(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    protected Locale getCurrentLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Locale l = this.localeGroup.getLocale();
        if (l != null) {
            return l;
        }
        return Locale.getDefault();
    }

    protected boolean setUsedLocale() {
        Locale l = this.getCurrentLocale();
        if (this.usedLocale == l) {
            return false;
        }
        this.usedLocale = l;
        this.resourceBundles.clear();
        this.lastResourceClass = null;
        return true;
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(0);
    }

    protected boolean hasNextResourceBundle(int i2) {
        if (i2 == 0) {
            return true;
        }
        if (i2 < this.resourceBundles.size()) {
            return true;
        }
        if (this.lastResourceClass == null) {
            return false;
        }
        return this.lastResourceClass != (class$java$lang$Object == null ? (class$java$lang$Object = LocalizableSupport.class$("java.lang.Object")) : class$java$lang$Object);
    }

    protected ResourceBundle lookupResourceBundle(String bundle, Class theClass) {
        ClassLoader cl = this.classLoader;
        ResourceBundle rb = null;
        if (cl != null) {
            try {
                rb = ResourceBundle.getBundle(bundle, this.usedLocale, cl);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (rb != null) {
                return rb;
            }
        }
        if (theClass != null) {
            try {
                cl = theClass.getClassLoader();
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            rb = ResourceBundle.getBundle(bundle, this.usedLocale, cl);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return rb;
    }

    /*
     * Unable to fully structure code
     */
    protected ResourceBundle getResourceBundle(int i) {
        this.setUsedLocale();
        rb = null;
        if (this.cls != null) ** GOTO lbl17
        if (this.resourceBundles.size() == 0) {
            rb = this.lookupResourceBundle(this.bundleName, null);
            this.resourceBundles.add(rb);
        }
        return (ResourceBundle)this.resourceBundles.get(0);
lbl-1000:
        // 1 sources

        {
            if (this.lastResourceClass == (LocalizableSupport.class$java$lang$Object == null ? LocalizableSupport.class$("java.lang.Object") : LocalizableSupport.class$java$lang$Object)) {
                return null;
            }
            this.lastResourceClass = this.lastResourceClass == null ? this.cls : this.lastResourceClass.getSuperclass();
            cl = this.lastResourceClass;
            bundle = cl.getPackage().getName() + "." + this.bundleName;
            this.resourceBundles.add(this.lookupResourceBundle(bundle, cl));
lbl17:
            // 2 sources

            ** while (i >= this.resourceBundles.size())
        }
lbl18:
        // 1 sources

        return (ResourceBundle)this.resourceBundles.get(i);
    }

    public String getString(String key) throws MissingResourceException {
        this.setUsedLocale();
        int i2 = 0;
        while (this.hasNextResourceBundle(i2)) {
            ResourceBundle rb = this.getResourceBundle(i2);
            if (rb != null) {
                try {
                    String ret = rb.getString(key);
                    if (ret != null) {
                        return ret;
                    }
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            ++i2;
        }
        String classStr = this.cls != null ? this.cls.toString() : this.bundleName;
        throw new MissingResourceException("Unable to find resource: " + key, classStr, key);
    }

    public int getInteger(String key) throws MissingResourceException {
        String i2 = this.getString(key);
        try {
            return Integer.parseInt(i2);
        }
        catch (NumberFormatException e2) {
            throw new MissingResourceException("Malformed integer", this.bundleName, key);
        }
    }

    public int getCharacter(String key) throws MissingResourceException {
        String s = this.getString(key);
        if (s == null || s.length() == 0) {
            throw new MissingResourceException("Malformed character", this.bundleName, key);
        }
        return s.charAt(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

