/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Utilities {
    private static Logger log = Logger.getLogger(Utilities.class);
    static final int ZIP_ENTRY_CHUNK_SIZE = 64000;

    public static String base64Encode(String str) {
        BASE64Encoder encoder = new BASE64Encoder();
        byte[] bytes = str.getBytes();
        return encoder.encode(bytes);
    }

    public static String base64Decode(String str) {
        try {
            return new String(new BASE64Decoder().decodeBuffer(str));
        }
        catch (IOException e2) {
            log.error("Error decoding string: " + str, e2);
            return str;
        }
    }

    public static final File changeFileExtension(File file, String extension) {
        if (file == null || extension == null || extension.trim().equals("")) {
            return null;
        }
        String path = file.getAbsolutePath();
        String newPath = "";
        String filename = file.getName().trim();
        if (filename != null && !filename.equals("")) {
            int periodIndex = path.lastIndexOf(".");
            newPath = path.substring(0, periodIndex);
            newPath = newPath + extension;
        }
        return new File(newPath);
    }

    public static Document createDOMDocumentFromXmlFile(File file) throws ParserConfigurationException, IOException, SAXException {
        if (!file.exists()) {
            throw new RuntimeException("Could not find XML file: " + file.getAbsolutePath());
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDocument = documentBuilder.parse(file);
        return xmlDocument;
    }

    public static Document createDOMDocumentFromXmlStream(InputStream inStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document xmlDocument = documentBuilder.parse(inStream);
        return xmlDocument;
    }

    public static Comparator getNumericStringComparator() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                StringTokenizer st1 = new StringTokenizer(s1, " ");
                StringTokenizer st2 = new StringTokenizer(s2, " ");
                while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
                    int c2;
                    String t1 = st1.nextToken();
                    String t2 = st2.nextToken();
                    try {
                        Integer i1 = new Integer(t1);
                        Integer i2 = new Integer(t2);
                        c2 = i1.compareTo(i2);
                    }
                    catch (NumberFormatException e2) {
                        c2 = t1.compareTo(t2);
                    }
                    if (c2 == 0) continue;
                    return c2;
                }
                return 0;
            }
        };
        return comparator;
    }

    public static ZipEntry createZipEntry(String entryName, byte[] bytes, ZipOutputStream zipOutputStream, boolean isCompressed) throws IOException, IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        if (isCompressed) {
            zipEntry.setMethod(8);
        } else {
            zipEntry.setMethod(0);
            zipEntry.setCompressedSize(bytes.length);
            zipEntry.setSize(bytes.length);
            zipEntry.setCrc(Utilities.getCrc(bytes));
        }
        zipOutputStream.putNextEntry(zipEntry);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
        bufferedOutputStream.write(bytes);
        bufferedOutputStream.flush();
        zipOutputStream.closeEntry();
        return zipEntry;
    }

    private static long getCrc(byte[] buffer) throws IOException {
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(buffer, 0, buffer.length);
        return crc.getValue();
    }

    public static String getFileNameFromURL(String url) {
        int lastIndexOfSlash = url.lastIndexOf("/");
        String fileName = null;
        fileName = lastIndexOfSlash > -1 ? url.substring(lastIndexOfSlash, url.length()) : url;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createZipFile(File zipOutputFile, File[] inputFiles) throws FileNotFoundException, IOException {
        if (zipOutputFile == null) {
            return;
        }
        if (inputFiles == null || inputFiles.length == 0) {
            return;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipOutputFile));
            for (File file : inputFiles) {
                Object var15_13;
                if (file == null) continue;
                long fileLength = file.length();
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipEntry.setSize(fileLength);
                zipOutputStream.putNextEntry(zipEntry);
                BufferedInputStream bufferedInputstream = null;
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    bufferedInputstream = new BufferedInputStream(inputStream);
                    int bytesRead = 0;
                    byte[] data = new byte[64000];
                    while ((bytesRead = bufferedInputstream.read(data)) != -1) {
                        zipOutputStream.write(data, 0, bytesRead);
                    }
                    var15_13 = null;
                    if (bufferedInputstream == null) continue;
                }
                catch (Throwable throwable) {
                    var15_13 = null;
                    if (bufferedInputstream == null) throw throwable;
                    bufferedInputstream.close();
                    throw throwable;
                }
                bufferedInputstream.close();
                {
                }
            }
            Object var17_15 = null;
            if (zipOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            if (zipOutputStream == null) throw throwable;
            zipOutputStream.flush();
            zipOutputStream.close();
            throw throwable;
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    public static File getFileFromURL(URL url) {
        return Utilities.getFileFromURLString(url.toExternalForm());
    }

    public static File getFileFromURLString(String urlText) {
        File file = null;
        try {
            URL url = new URL(urlText);
            URI uri = url.toURI();
            file = new File(uri.getPath());
        }
        catch (MalformedURLException e2) {
            log.error(e2.getMessage(), e2);
        }
        catch (URISyntaxException e3) {
            log.error(e3.getMessage(), e3);
        }
        return file;
    }

    /*
     * Unable to fully structure code
     */
    public static final String[] fastSplit(String text, String delimeter) {
        list = new ArrayList<String>();
        if (text == null || text.length() < 1) {
            return new String[0];
        }
        block0: while (true) {
            if ((index = text.indexOf(delimeter)) == -1) {
                if (text.length() <= 0) break;
                list.add(text);
                break;
            }
            if (text.length() <= 0) continue;
            newText = text.substring(0, index);
            while (newText.startsWith(delimeter)) {
                newText = newText.substring(1, newText.length());
            }
            if (newText.length() > 0) {
                list.add(newText);
            }
            if ((length = text.length()) <= 1) continue;
            text = text.substring(index + 1, length);
            while (true) {
                if (text.startsWith(delimeter)) ** break;
                continue block0;
                text = text.substring(1, text.length());
            }
            break;
        }
        return list.toArray(new String[list.size()]);
    }
}

