/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Temp {
    public static void main(String[] args) throws IOException, InterruptedException {
        Temp.fixDicty();
    }

    public static void fixDicty() throws IOException, InterruptedException {
        String dir = "/Users/jrobinso/IGV/dicty";
        HashMap<String, String> chrMap = new HashMap<String, String>();
        chrMap.put("DDB0169550", "M");
        chrMap.put("DDB0215018", "3F");
        chrMap.put("DDB0215151", "2F");
        chrMap.put("DDB0220052", "BF");
        chrMap.put("DDB0232428", "1");
        chrMap.put("DDB0232429", "2");
        chrMap.put("DDB0232430", "3");
        chrMap.put("DDB0232431", "4");
        chrMap.put("DDB0232432", "5");
        chrMap.put("DDB0232433", "6");
        chrMap.put("DDB0237465", "R");
        File gffDir = new File(dir, "gff3");
        for (File f2 : gffDir.listFiles()) {
            if (!f2.getName().endsWith("gff")) continue;
            StringBuffer sedExpression = new StringBuffer();
            Iterator iter = chrMap.entrySet().iterator();
            Map.Entry first = iter.next();
            sedExpression.append("sed 's/" + (String)first.getKey() + "/" + (String)first.getValue() + "/g' " + f2.getAbsolutePath());
            while (iter.hasNext()) {
                first = iter.next();
                sedExpression.append(" | ");
                sedExpression.append("sed 's/" + (String)first.getKey() + "/" + (String)first.getValue() + "/g'");
            }
            String outputFile = f2.getAbsolutePath().replace("chromosome_", "chr");
            String cmdLine = sedExpression.toString() + " > " + outputFile;
            Process p2 = Runtime.getRuntime().exec(cmdLine);
            p2.waitFor();
            System.out.println(cmdLine);
            System.out.println(p2.exitValue());
        }
    }

    public static void makeSampleInfo() throws Exception {
        HashSet<String> sec = new HashSet<String>(Arrays.asList("TCGA-02-0010", "TCGA-02-0028", "TCGA-02-0102", "TCGA-02-0114", "TCGA-08-0525"));
        HashSet<String> treat = new HashSet<String>(Arrays.asList("TCGA-02-0001", "TCGA-02-0007", "TCGA-02-0010", "TCGA-02-0014", "TCGA-02-0021", "TCGA-02-0024", "TCGA-02-0028", "TCGA-02-0043", "TCGA-02-0057", "TCGA-02-0058", "TCGA-02-0080", "TCGA-02-0083", "TCGA-02-0089", "TCGA-02-0099", "TCGA-02-0102", "TCGA-02-0107", "TCGA-02-0113", "TCGA-02-0114", "TCGA-02-0116", "TCGA-08-0517", "TCGA-08-0525"));
        HashSet<String> hyper = new HashSet<String>(Arrays.asList("TCGA-02-0010", "TCGA-02-0014", "TCGA-02-0028", "TCGA-02-0043", "TCGA-02-0083", "TCGA-02-0099", "TCGA-02-0114", "TCGA-02-0015", "TCGA-02-0070"));
        BufferedReader br = new BufferedReader(new FileReader("Public_IGV_TCGA_sample_info_20080827.txt"));
        PrintWriter pw = new PrintWriter(new FileWriter("Sample_info.txt"));
        String nextLine = br.readLine();
        pw.println(nextLine + "\tTreated\tPrimary/Secondary\tHypermutated");
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            String sample = tokens[0].length() > 12 ? tokens[0].substring(0, 12) : tokens[0];
            String t = treat.contains(sample) ? "Y" : "";
            String s = sec.contains(sample) ? "Secondary" : "Primary";
            String h2 = hyper.contains(sample) ? "Y" : "";
            pw.println(nextLine + "\t" + t + "\t" + s + "\t" + h2);
        }
        pw.close();
        br.close();
    }
}

