/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.SeekableStream;

public class SeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private static final String WEBSERVICE_URL = "http://www.broadinstitute.org/webservices/igv";
    private static final String IGV_DATA_HOST = "www.broadinstitute.org";
    private static final String DATA_PATH = "/xchip/igv/data/public";
    private static final String DATA_HTTP_PATH = "/igvdata";
    private long position = 0L;
    private long contentLength = -1L;
    private URL url;

    SeekableHTTPStream(URL url) {
        this.url = url;
        String contentLengthString = IGVHttpUtils.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            log.error("Null content-length for: " + url);
            throw new RuntimeException("Error loading file: " + url + " NULL content-length");
        }
        try {
            this.contentLength = Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e2) {
            log.error("Error converting content length to number: " + this.contentLength);
            throw new RuntimeException("Error loading file: " + url + " Invalid content-length returned: " + contentLengthString);
        }
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        if (this.contentLength > 0L) {
            bytesToSkip = Math.min(n2, this.contentLength - this.position);
        }
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        boolean useByteRange = IGVHttpUtils.useByteRange();
        return this.read(buffer, offset, len, useByteRange);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] buffer, int offset, int len, boolean useByteRange) throws IOException {
        int n2;
        InputStream is;
        block16: {
            int n3;
            block15: {
                int n4;
                block14: {
                    int nBytes;
                    if (offset < 0) throw new IndexOutOfBoundsException();
                    if (len < 0) throw new IndexOutOfBoundsException();
                    if (offset + len > buffer.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return 0;
                    }
                    if (!useByteRange && (nBytes = this.readFromWebservice(buffer, offset, len)) > 0) {
                        return nBytes;
                    }
                    is = null;
                    String byteRange = "";
                    int n5 = 0;
                    try {
                        try {
                            HashMap<String, String> props = new HashMap<String, String>();
                            long endRange = this.position + (long)len - 1L;
                            if (this.contentLength > 0L) {
                                endRange = Math.min(endRange, this.contentLength);
                            }
                            byteRange = "bytes=" + this.position + "-" + endRange;
                            if (endRange < this.position) {
                                log.error("Invalid byteRange: " + byteRange);
                                n4 = 0;
                                Object var14_16 = null;
                                if (is == null) return n4;
                                break block14;
                            }
                            props.put("Range", byteRange);
                            is = IGVHttpUtils.openHttpStream(this.url, props);
                            while (n5 < len) {
                                int count = is.read(buffer, offset + n5, len - n5);
                                if (count < 0) {
                                    if (n5 != 0) break;
                                    n3 = -1;
                                    break block15;
                                }
                                n5 += count;
                            }
                            this.position += (long)n5;
                            n2 = n5;
                            break block16;
                        }
                        catch (IOException e2) {
                            if (!e2.getMessage().contains("416")) {
                                if (!(e2 instanceof EOFException)) throw e2;
                            }
                            log.error("Server returned 416 for: " + byteRange + " content-length = " + this.contentLength + "  URL: " + this.url);
                            if (n5 < 0) {
                                int n6 = -1;
                                Object var14_19 = null;
                                if (is == null) return n6;
                                is.close();
                                return n6;
                            }
                            this.position += (long)n5;
                            int n7 = n5;
                            Object var14_20 = null;
                            if (is == null) return n7;
                            is.close();
                            return n7;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                }
                is.close();
                return n4;
            }
            Object var14_17 = null;
            if (is == null) return n3;
            is.close();
            return n3;
        }
        Object var14_18 = null;
        if (is == null) return n2;
        is.close();
        return n2;
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    private void logHeaderFields(HttpURLConnection connection) {
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            System.out.print(entry.getKey() + ":\t");
            for (String v : entry.getValue()) {
                System.out.print(v + " ");
            }
            System.out.println();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromWebservice(byte[] buffer, int offset, int length) throws IOException {
        int count;
        InputStream is;
        HttpURLConnection connection;
        block13: {
            int n2;
            block11: {
                block12: {
                    String host = this.url.getHost();
                    if (host == null) return -1;
                    if (!host.equals(IGV_DATA_HOST)) {
                        return -1;
                    }
                    if (length < 0) throw new IndexOutOfBoundsException();
                    if (offset < 0) throw new IndexOutOfBoundsException();
                    if (offset + length > buffer.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    connection = null;
                    is = null;
                    String path = this.url.getPath().replaceFirst(DATA_HTTP_PATH, DATA_PATH);
                    URL webserviceURL = new URL("http://www.broadinstitute.org/webservices/igv?method=getRange&file=" + path + "&position=" + this.position + "&length=" + length);
                    try {
                        try {
                            int n3;
                            connection = (HttpURLConnection)webserviceURL.openConnection();
                            is = connection.getInputStream();
                            for (n3 = 0; n3 < length; n3 += count) {
                                count = is.read(buffer, offset + n3, length - n3);
                                if (count >= 0) continue;
                                n2 = n3 == 0 ? -1 : n3;
                                Object var13_13 = null;
                                if (is == null) break block11;
                                break block12;
                            }
                            this.position += (long)n3;
                            if (log.isDebugEnabled()) {
                                log.debug("Webservice range request: expected=" + length + " received=" + n3);
                            }
                            count = n3;
                            break block13;
                        }
                        catch (IOException e2) {
                            log.error("Error doing webservice range query", e2);
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (is != null) {
                            is.close();
                        }
                        if (connection == null) throw throwable;
                        connection.disconnect();
                        throw throwable;
                    }
                }
                is.close();
            }
            if (connection == null) return n2;
            connection.disconnect();
            return n2;
        }
        Object var13_14 = null;
        if (is != null) {
            is.close();
        }
        if (connection == null) return count;
        connection.disconnect();
        return count;
    }
}

