/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    Logger log = Logger.getLogger(LRUCache.class);
    private static Map<Object, LRUCache> instances = Collections.synchronizedMap(new WeakHashMap());
    private final int maxEntries;
    private SoftReference<Map<K, V>> mapReference;

    public static void clearCaches() {
        for (LRUCache cache : instances.values()) {
            if (cache == null) continue;
            cache.clear();
        }
    }

    public LRUCache(Object source, int max) {
        instances.put(source, this);
        this.maxEntries = max;
        this.createMap();
    }

    private void createMap() {
        this.mapReference = new SoftReference(Collections.synchronizedMap(new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.maxEntries;
            }
        }));
    }

    private Map<K, V> getMap() {
        if (this.mapReference == null || this.mapReference.get() == null) {
            this.createMap();
        }
        return this.mapReference.get();
    }

    public V put(K k2, V v) {
        return this.getMap().put(k2, v);
    }

    public V get(Object key) {
        return this.getMap().get(key);
    }

    public boolean containsKey(Object o2) {
        return this.getMap().containsKey(o2);
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public void clear() {
        this.getMap().clear();
    }
}

