/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.panel.AttributePanel;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.TrackNamePanel;
import org.broad.igv.ui.panel.TrackPanel;

public class TrackPanelScrollPane
extends JideScrollPane {
    TrackPanel trackPanel;

    public void setViewportView(Component trackSetView) {
        if (!(trackSetView instanceof TrackPanel)) {
            throw new IllegalArgumentException("Class TrackPanelScrollPane can only contain a TrackPanel");
        }
        super.setViewportView(trackSetView);
        this.trackPanel = (TrackPanel)trackSetView;
        this.verticalScrollBar.addAdjustmentListener(this.getNamePanel());
        this.init();
    }

    public TrackPanel getTrackPanel() {
        return this.trackPanel;
    }

    public String getName() {
        return this.trackPanel.getName();
    }

    public void minimizeHeight() {
        int prefHeight = this.trackPanel.getPreferredPanelHeight();
        if (prefHeight < this.trackPanel.getViewportHeight()) {
            this.setSize(this.getWidth(), prefHeight);
        }
    }

    public DataPanel getDataPanel() {
        return this.trackPanel.getDataPanel();
    }

    public boolean isEmpty() {
        return !this.trackPanel.hasTracks();
    }

    public TrackNamePanel getNamePanel() {
        return this.trackPanel.getNamePanel();
    }

    public AttributePanel getAttributePanel() {
        return this.trackPanel.getAttributePanel();
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private boolean tracksAreLoaded() {
        return IGVMainFrame.getInstance().getTrackManager().getAllTracks(false).size() > 0;
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(22);
        this.setFocusTraversalPolicyProvider(true);
        this.setMinimumSize(new Dimension(0, 0));
        this.setOpaque(false);
    }
}

